/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.db;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.List;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Mapper;
import org.molgenis.util.Entity;

public abstract class AbstractMapper<E extends Entity>
implements Mapper<E> {
    private final Database database;
    public static final int BATCH_SIZE = 500;
    private static final Logger logger = Logger.getLogger(AbstractMapper.class);

    public AbstractMapper(Database database) {
        this.database = database;
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    @Override
    public abstract E create();

    @Override
    public abstract List<E> createList(int var1);

    protected abstract void prepareFileAttachements(List<E> var1, File var2) throws IOException;

    protected abstract boolean saveFileAttachements(List<E> var1, File var2) throws IOException;

    @Override
    public abstract int executeAdd(List<? extends E> var1) throws DatabaseException;

    @Override
    public abstract int executeUpdate(List<? extends E> var1) throws DatabaseException;

    @Override
    public abstract int executeRemove(List<? extends E> var1) throws DatabaseException;

    @Override
    public abstract void resolveForeignKeys(List<E> var1) throws DatabaseException, ParseException;

    public abstract void storeMrefs(List<E> var1) throws DatabaseException, IOException, ParseException;

    public abstract void removeMrefs(List<E> var1) throws SQLException, IOException, DatabaseException, ParseException;

    public int add(E entity) throws DatabaseException {
        List<E> entities = this.createList(1);
        entities.add(entity);
        return this.add(entities);
    }

    @Override
    public int add(List<E> entities) throws DatabaseException {
        int updatedRows = 0;
        try {
            this.prepareFileAttachements(entities, this.getDatabase().getFilesource());
            for (int i = 0; i < entities.size(); i += 500) {
                this.resolveForeignKeys(entities);
                int endindex = Math.min(i + 500, entities.size());
                List<E> sublist = entities.subList(i, endindex);
                updatedRows += this.executeAdd(sublist);
            }
            this.storeMrefs(entities);
            if (this.saveFileAttachements(entities, this.getDatabase().getFilesource())) {
                this.update(entities);
            }
            logger.debug((Object)(updatedRows + " " + this.create().getClass().getSimpleName() + " objects added"));
            return updatedRows;
        }
        catch (Exception sqle) {
            sqle.printStackTrace();
            logger.error((Object)("ADD failed on " + this.create().getClass().getSimpleName() + ": " + sqle.getMessage()));
            throw new DatabaseException(sqle);
        }
    }

    public int update(E entity) throws DatabaseException {
        List<E> entities = this.createList(1);
        entities.add(entity);
        return this.update(entities);
    }

    @Override
    public int update(List<E> entities) throws DatabaseException {
        int updatedRows = 0;
        try {
            this.prepareFileAttachements(entities, this.getDatabase().getFilesource());
            for (int i = 0; i < entities.size(); i += 500) {
                int endindex = Math.min(i + 500, entities.size());
                List<E> sublist = entities.subList(i, endindex);
                this.saveFileAttachements(sublist, this.getDatabase().getFilesource());
                this.resolveForeignKeys(sublist);
                updatedRows += this.executeUpdate(sublist);
            }
            this.storeMrefs(entities);
            logger.info((Object)(updatedRows + " " + this.create().getClass().getSimpleName() + " objects updated"));
            return updatedRows;
        }
        catch (Exception sqle) {
            throw new DatabaseException("Update(" + this.create().getClass().getSimpleName() + ") failed: " + sqle.getMessage(), sqle);
        }
    }

    public int remove(E entity) throws DatabaseException {
        List<E> entities = this.createList(1);
        entities.add(entity);
        return this.remove(entities);
    }

    @Override
    public int remove(List<E> entities) throws DatabaseException {
        int updatedRows = 0;
        try {
            this.prepareFileAttachements(entities, this.getDatabase().getFilesource());
            for (int i = 0; i < entities.size(); i += 500) {
                int endindex = Math.min(i + 500, entities.size());
                List<E> sublist = entities.subList(i, endindex);
                this.resolveForeignKeys(sublist);
                this.removeMrefs(sublist);
                updatedRows += this.executeRemove(sublist);
                this.getDatabase().flush();
            }
            this.getDatabase().flush();
            logger.info((Object)(updatedRows + " " + this.create().getClass().getSimpleName() + " objects removed"));
            return updatedRows;
        }
        catch (Exception sqle) {
            logger.error((Object)("remove failed on " + this.create().getClass().getSimpleName() + ": " + sqle.getMessage()));
            sqle.printStackTrace();
            throw new DatabaseException("remove(" + this.create().getClass().getSimpleName() + ") failed: " + sqle.getMessage(), sqle);
        }
    }
}

