/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.db;

import java.io.Closeable;
import java.io.File;
import java.util.List;
import javax.persistence.EntityManager;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Mapper;
import org.molgenis.framework.db.Query;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.model.elements.Model;
import org.molgenis.util.Entity;
import org.springframework.transaction.annotation.Transactional;

public interface Database
extends Closeable {
    public Model getMetaData() throws DatabaseException;

    @Transactional(readOnly=true, rollbackFor={DatabaseException.class})
    public <E extends Entity> int count(Class<E> var1, QueryRule ... var2) throws DatabaseException;

    @Transactional(readOnly=true, rollbackFor={DatabaseException.class})
    public <E extends Entity> List<E> find(Class<E> var1, QueryRule ... var2) throws DatabaseException;

    @Transactional(readOnly=true, rollbackFor={DatabaseException.class})
    public <E extends Entity> E findById(Class<E> var1, Object var2) throws DatabaseException;

    public <E extends Entity> Query<E> query(Class<E> var1);

    public <E extends Entity> Query<E> queryByExample(E var1);

    @Transactional(rollbackFor={DatabaseException.class})
    public <E extends Entity> int add(E var1) throws DatabaseException;

    @Transactional(rollbackFor={DatabaseException.class})
    public <E extends Entity> int add(List<E> var1) throws DatabaseException;

    @Transactional(rollbackFor={DatabaseException.class})
    public <E extends Entity> int update(E var1) throws DatabaseException;

    @Transactional(rollbackFor={DatabaseException.class})
    public <E extends Entity> int update(List<E> var1) throws DatabaseException;

    @Transactional(rollbackFor={DatabaseException.class})
    public <E extends Entity> int remove(E var1) throws DatabaseException;

    @Transactional(rollbackFor={DatabaseException.class})
    public <E extends Entity> int remove(List<E> var1) throws DatabaseException;

    @Transactional(rollbackFor={DatabaseException.class})
    public <E extends Entity> int update(List<E> var1, DatabaseAction var2, String ... var3) throws DatabaseException;

    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public File getFilesource() throws Exception;

    public List<Class<? extends Entity>> getEntityClasses();

    public List<String> getEntityNames();

    public Class<? extends Entity> getClassForName(String var1);

    public EntityManager getEntityManager();

    @Transactional(rollbackFor={DatabaseException.class})
    public void flush();

    public <E extends Entity> String createFindSql(Class<E> var1, QueryRule ... var2) throws DatabaseException;

    public <E extends Entity> Mapper<E> getMapper(String var1) throws DatabaseException;

    public <E extends Entity> Mapper<E> getMapperFor(Class<E> var1) throws DatabaseException;

    @Transactional(readOnly=true, rollbackFor={DatabaseException.class})
    public <E extends Entity> List<E> search(Class<E> var1, String var2) throws DatabaseException;

    @Transactional(readOnly=true, rollbackFor={DatabaseException.class})
    public <E extends Entity> List<? extends Entity> load(Class<E> var1, List<E> var2) throws DatabaseException;

    public <E extends Entity> Class<E> getEntityClass(E var1);

    public <E extends Entity> Class<E> getEntityClass(List<E> var1);

    public static enum DatabaseAction {
        ADD,
        ADD_IGNORE_EXISTING,
        ADD_UPDATE_EXISTING,
        UPDATE,
        UPDATE_IGNORE_MISSING,
        REMOVE,
        REMOVE_IGNORE_MISSING;

    }
}

