/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.db;

import java.util.List;
import java.util.Vector;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Query;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.SubQueryRule;
import org.molgenis.util.Entity;

public class QueryImp<E extends Entity>
implements Query<E> {
    private final Vector<QueryRule> rules = new Vector();
    private Class<E> klazz;
    private Database database;

    public Class<E> getKlazz() {
        return this.klazz;
    }

    public QueryImp() {
    }

    public QueryImp(Database db, Class<E> klazz) {
        this.database = db;
        this.klazz = klazz;
    }

    public QueryImp(Class<E> klazz) {
        this.klazz = klazz;
    }

    @Override
    public Query<E> filter(String filter) {
        String[] args = filter.split(" ");
        this.rules.add(new QueryRule(args[0], QueryRule.Operator.valueOf(args[1]), args[2]));
        return this;
    }

    @Override
    public Query<E> equals(String field, Object value) {
        this.rules.add(new QueryRule(field, QueryRule.Operator.EQUALS, value));
        return this;
    }

    @Override
    public Query<E> search(String searchTerms) {
        this.rules.add(new QueryRule(QueryRule.Operator.SEARCH, searchTerms));
        return this;
    }

    @Override
    public Query<E> in(String field, List<?> values) {
        if (values.size() > 0) {
            this.rules.add(new QueryRule(field, QueryRule.Operator.IN, values.toArray()));
        }
        return this;
    }

    @Override
    public Query<E> subquery(String field, String sql) {
        this.rules.add(new QueryRule(field, QueryRule.Operator.IN_SUBQUERY, sql));
        return this;
    }

    @Override
    public Query<E> subQuery(SubQueryRule subQueryRule) {
        this.rules.add(subQueryRule);
        return this;
    }

    @Override
    public Query<E> greater(String field, Object value) {
        this.rules.add(new QueryRule(field, QueryRule.Operator.GREATER, value));
        return this;
    }

    @Override
    public Query<E> greaterOrEqual(String field, Object value) {
        this.rules.add(new QueryRule(field, QueryRule.Operator.GREATER_EQUAL, value));
        return this;
    }

    @Override
    public Query<E> less(String field, Object value) {
        this.rules.add(new QueryRule(field, QueryRule.Operator.LESS, value));
        return this;
    }

    @Override
    public Query<E> lessOrEqual(String field, Object value) {
        this.rules.add(new QueryRule(field, QueryRule.Operator.LESS_EQUAL, value));
        return this;
    }

    @Override
    public Query<E> between(String field, Object min, Object max) {
        return this.lessOrEqual(field, max).greaterOrEqual(field, min);
    }

    @Override
    public Query<E> like(String field, Object value) {
        this.rules.add(new QueryRule(field, QueryRule.Operator.LIKE, value));
        return this;
    }

    @Override
    public Query<E> last() {
        this.rules.add(new QueryRule(QueryRule.Operator.LAST));
        return this;
    }

    @Override
    public Query<E> or() {
        this.rules.add(new QueryRule(QueryRule.Operator.OR));
        return this;
    }

    @Override
    public Query<E> and() {
        this.rules.add(new QueryRule(QueryRule.Operator.AND));
        return this;
    }

    @Override
    public Query<E> limit(int limit) {
        this.rules.add(new QueryRule(QueryRule.Operator.LIMIT, limit));
        return this;
    }

    @Override
    public Query<E> offset(int offset) {
        this.rules.add(new QueryRule(QueryRule.Operator.OFFSET, offset));
        return this;
    }

    @Override
    public Query<E> sortASC(String orderByField) {
        this.rules.add(new QueryRule(QueryRule.Operator.SORTASC, orderByField));
        return this;
    }

    @Override
    public Query<E> sortDESC(String orderByField) {
        this.rules.add(new QueryRule(QueryRule.Operator.SORTDESC, orderByField));
        return this;
    }

    @Override
    public QueryRule[] getRules() {
        return this.rules.toArray(new QueryRule[this.rules.size()]);
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        for (QueryRule rule : this.getRules()) {
            strBuilder.append(rule.toString());
        }
        return strBuilder.toString();
    }

    public void addRules(List<QueryRule> addRules) {
        if (addRules != null) {
            this.addRules(addRules.toArray(new QueryRule[addRules.size()]));
        }
    }

    @Override
    public void addRules(QueryRule ... addRules) {
        for (QueryRule rule : addRules) {
            this.rules.add(rule);
        }
    }

    @Override
    public List<E> find() throws DatabaseException {
        if (this.klazz != null && this.database != null) {
            return this.find(this.database, this.klazz);
        }
        throw new UnsupportedOperationException("Cannot execute this find query because no database and entity is provided. Use find(Database,Class)");
    }

    @Override
    public List<E> find(Database db, Class<E> klazz) throws DatabaseException {
        return db.find(klazz, this.getRules());
    }

    @Override
    public int count() throws DatabaseException {
        if (this.klazz != null && this.database != null) {
            return this.count(this.database, this.klazz);
        }
        throw new UnsupportedOperationException("Cannot execute this count query because no database and entity is provided. Use count(Database,Class)");
    }

    @Override
    public int count(Database db, Class<E> klazz) throws DatabaseException {
        return db.count(klazz, this.getRules());
    }

    @Override
    public Query<E> eq(String field, Object value) {
        return this.equals(field, value);
    }

    @Override
    public Query<E> gt(String field, Object value) {
        return this.greater(field, value);
    }

    @Override
    public Query<E> lt(String field, Object value) {
        return this.less(field, value);
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    @Override
    public void setDatabase(Database db) {
        this.database = db;
    }

    @Override
    public Query<E> example(Entity example) {
        for (String field : example.getFields()) {
            if (example.get(field) == null) continue;
            if (example.get(field) instanceof List) {
                if (((List)example.get(field)).size() <= 0) continue;
                this.in(field, (List)example.get(field));
                continue;
            }
            this.equals(field, example.get(field));
        }
        return this;
    }

    @Override
    public void removeRule(QueryRule ruleToBeRemoved) {
        try {
            this.rules.remove(ruleToBeRemoved);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("ArrayIndexOutOfBoundsException " + e.getLocalizedMessage());
        }
    }

    @Override
    public String createFindSql() throws DatabaseException {
        return this.database.createFindSql(this.klazz, this.getRules());
    }
}

