/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.db;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class QueryRule {
    protected Operator operator;
    protected String field = null;
    protected Object value = null;
    private QueryRule[] nestedRules;

    public QueryRule() {
    }

    public QueryRule(QueryRule copy) {
        this.operator = copy.operator;
        this.field = copy.field;
        this.value = copy.value;
        if (copy.nestedRules != null) {
            this.nestedRules = new QueryRule[copy.nestedRules.length];
            for (int i = 0; i < copy.nestedRules.length; ++i) {
                this.nestedRules[i] = new QueryRule(copy.nestedRules[i]);
            }
        }
    }

    public QueryRule(String field, Operator operator, Object value) {
        if (operator == Operator.LIMIT || operator == Operator.OFFSET || operator == Operator.SORTASC || operator == Operator.SORTDESC || operator == Operator.LAST || operator == Operator.AND || operator == Operator.OR) {
            throw new IllegalArgumentException("QueryRule(): Operator." + (Object)((Object)operator) + " cannot be used with two arguments");
        }
        this.field = field;
        this.operator = operator;
        this.value = value;
    }

    public QueryRule(QueryRule ... rules) {
        this.operator = Operator.NESTED;
        this.nestedRules = rules;
    }

    public QueryRule(Operator operator, Object value) {
        if (operator != Operator.LIMIT && operator != Operator.OFFSET && operator != Operator.SORTASC && operator != Operator.SORTDESC && operator != Operator.SEARCH) {
            throw new IllegalArgumentException("QueryRule(): Operator." + (Object)((Object)operator) + " cannot be used with one argument");
        }
        this.operator = operator;
        this.value = value;
    }

    public QueryRule(Operator operator, QueryRule nestedRules) {
        if (operator != Operator.NOT && operator != Operator.IN_SUBQUERY) {
            throw new IllegalArgumentException("QueryRule(): Operator." + (Object)((Object)operator) + " cannot be used with one argument");
        }
        this.operator = operator;
        this.nestedRules = new QueryRule[]{nestedRules};
    }

    public QueryRule(Operator operator) {
        if (operator != Operator.LAST && operator != Operator.AND && operator != Operator.OR) {
            throw new IllegalArgumentException("QueryRule(): Operator '" + (Object)((Object)operator) + "' cannot be used without arguments");
        }
        this.operator = operator;
    }

    public QueryRule(List<QueryRule> rules) {
        this(rules.toArray(new QueryRule[rules.size()]));
    }

    public QueryRule(String field, Operator equals, String value) {
        this(field, equals, (Object)value);
    }

    public String getField() {
        return this.field;
    }

    public String getJpaAttribute() {
        if (!StringUtils.isEmpty((CharSequence)this.field)) {
            return this.field.substring(0, 1).toLowerCase() + this.field.substring(1);
        }
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public QueryRule[] getNestedRules() {
        return this.nestedRules;
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        if (this.getOperator() != null && this.getOperator().equals((Object)Operator.NESTED)) {
            strBuilder.append('(');
            for (QueryRule rule : this.getNestedRules()) {
                strBuilder.append(rule.toString());
            }
            strBuilder.append(')');
        } else {
            strBuilder.append(this.getField() == null ? " " : this.getField() + " ");
            strBuilder.append((Object)this.getOperator()).append(this.value == null ? " " : " '" + this.value + "'");
        }
        return strBuilder.toString();
    }

    public static QueryRule eq(String name, Object value) {
        return new QueryRule(name, Operator.EQUALS, value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
        result = 31 * result + Arrays.hashCode(this.nestedRules);
        result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueryRule other = (QueryRule)obj;
        if (this.field == null ? other.field != null : !this.field.equals(other.field)) {
            return false;
        }
        if (!Arrays.equals(this.nestedRules, other.nestedRules)) {
            return false;
        }
        if (this.operator != other.operator) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public static enum Operator {
        SHOULD("SHOULD"),
        DIS_MAX("DIS_MAX"),
        SEARCH("search"),
        EQUALS("="),
        IN("IN"),
        IN_SUBQUERY("IN_SUB"),
        SUBQUERY("SUBQUERY"),
        LESS("<"),
        LESS_EQUAL("<="),
        GREATER(">"),
        GREATER_EQUAL(">="),
        LIKE("LIKE"),
        NOT("!="),
        LIMIT("LIMIT"),
        OFFSET("OFFSET"),
        SORTASC("SORTASC"),
        SORTDESC("SORTDESC"),
        AND("AND"),
        OR("OR"),
        NESTED(""),
        LAST(""),
        JOIN("JOIN");

        private String label;

        private Operator(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

