/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.db;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.WebAppDatabasePopulatorService;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class WebAppDatabasePopulator
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger logger = Logger.getLogger(WebAppDatabasePopulator.class);
    private final WebAppDatabasePopulatorService webAppDatabasePopulatorService;

    public WebAppDatabasePopulator(WebAppDatabasePopulatorService webAppDatabasePopulatorService) {
        if (webAppDatabasePopulatorService == null) {
            throw new IllegalArgumentException("Web app database populator service is null");
        }
        this.webAppDatabasePopulatorService = webAppDatabasePopulatorService;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        try {
            if (!this.webAppDatabasePopulatorService.isDatabasePopulated()) {
                logger.info((Object)"initializing application database");
                this.webAppDatabasePopulatorService.populateDatabase();
                logger.info((Object)"initialized application database");
            }
        }
        catch (DatabaseException e) {
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
    }
}

