/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.db.jpa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Mapper;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.SubQueryRule;
import org.molgenis.framework.db.jpa.AbstractJpaMapper;
import org.molgenis.util.AbstractEntity;
import org.molgenis.util.Entity;

public class JpaQueryGeneratorUtil {
    private static final Logger logger = Logger.getLogger(JpaQueryGeneratorUtil.class);

    public static <IN extends Entity> TypedQuery<IN> createQuery(Database db, Class<IN> inputClass, Mapper<IN> mapper, EntityManager em, QueryRule ... rules) throws DatabaseException {
        return JpaQueryGeneratorUtil.createQuery(db, inputClass, inputClass, mapper, em, rules);
    }

    public static <IN extends Entity, OUT> TypedQuery<OUT> createQuery(Database db, Class<IN> inputClass, Class<OUT> outputClass, Mapper<IN> mapper, EntityManager em, QueryRule ... rules) throws DatabaseException {
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(outputClass);
        Root root = cq.from(inputClass);
        if (inputClass.getSimpleName().equals(outputClass.getSimpleName())) {
            cq.select((Selection)root);
        } else {
            cq.select((Selection)cb.count((Expression)root));
        }
        int[] limitOffset = new int[2];
        Arrays.fill(limitOffset, -1);
        Predicate wherePredicate = JpaQueryGeneratorUtil.createWhere(db, mapper, em, root, cq, cb, limitOffset, rules);
        if (wherePredicate != null) {
            cq.where((Expression)wherePredicate);
        }
        TypedQuery query = em.createQuery(cq);
        if (limitOffset[0] != -1) {
            query.setMaxResults(limitOffset[0]);
        }
        if (limitOffset[1] != -1) {
            query.setFirstResult(limitOffset[1]);
        }
        return query;
    }

    public static <E extends Entity> TypedQuery<Long> createCount(Database db, Class<E> entityClass, AbstractJpaMapper<E> abstractJpaMapper, EntityManager em, QueryRule ... rules) throws DatabaseException {
        ArrayList<QueryRule> limitLess = new ArrayList<QueryRule>();
        for (QueryRule r : rules) {
            if (QueryRule.Operator.OFFSET.equals((Object)r.getOperator())) continue;
            limitLess.add(r);
        }
        return JpaQueryGeneratorUtil.createQuery(db, entityClass, Long.class, abstractJpaMapper, em, limitLess.toArray(new QueryRule[limitLess.size()]));
    }

    private static <IN extends Entity, OUT> Predicate createWhere(Database db, Mapper<IN> mapper, EntityManager em, Root<IN> root, CriteriaQuery<OUT> cq, CriteriaBuilder cb, int[] limitOffset, QueryRule ... rul) throws DatabaseException {
        HashMap joinHash = new HashMap();
        return JpaQueryGeneratorUtil._createWhere(db, mapper, em, root, cq, cb, limitOffset, joinHash, rul);
    }

    private static <IN extends Entity, OUT> Predicate _createWhere(Database db, Mapper<IN> mapper, EntityManager em, Root<IN> root, CriteriaQuery<OUT> cq, CriteriaBuilder cb, int[] limitOffset, Map<String, Join<?, ?>> joinHash, QueryRule ... rul) throws DatabaseException {
        List<QueryRule> rules = Arrays.asList(rul);
        Predicate whereClause = null;
        ArrayList<Order> orders = new ArrayList<Order>();
        QueryRule prevRule = null;
        block24: for (int i = 0; i < rules.size(); ++i) {
            QueryRule rule = rules.get(i);
            if (mapper != null) {
                rule.setField(mapper.getTableFieldName(rule.getField()));
                QueryRule.Operator operator = rule.getOperator();
                if (operator == QueryRule.Operator.SORTASC || operator == QueryRule.Operator.SORTDESC) {
                    rule.setField(mapper.getTableFieldName(rule.getValue().toString()));
                }
                String attributeName = rule.getJpaAttribute();
                Predicate predicate = null;
                Path expression = JpaQueryGeneratorUtil._addJoin(rule, root, joinHash);
                Path lhs = null;
                if (expression != null) {
                    lhs = expression;
                } else if (attributeName != null) {
                    lhs = root.get(attributeName);
                }
                Object rhs = rule.getValue();
                switch (operator) {
                    case LAST: {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                    case SORTASC: {
                        orders.add(cb.asc((Expression)lhs));
                        break;
                    }
                    case SORTDESC: {
                        orders.add(cb.desc((Expression)lhs));
                        break;
                    }
                    case LIMIT: {
                        limitOffset[0] = (Integer)rule.getValue();
                        break;
                    }
                    case OFFSET: {
                        limitOffset[1] = (Integer)rule.getValue();
                        break;
                    }
                    default: {
                        switch (operator) {
                            case EQUALS: {
                                if (rhs instanceof Entity) {
                                    try {
                                        predicate = cb.equal((Expression)root.get(attributeName), rule.getValue());
                                    }
                                    catch (Exception ex) {
                                        logger.error((Object)ex);
                                    }
                                    break;
                                }
                                try {
                                    if (attributeName.contains(".") || root.get(attributeName).getJavaType().getName().equals("java.util.List") || root.get(attributeName).getJavaType().newInstance() instanceof Entity) {
                                        predicate = cb.equal((Expression)lhs, rhs);
                                        break;
                                    }
                                    predicate = cb.equal((Expression)lhs, rhs);
                                    break;
                                }
                                catch (InstantiationException ex) {
                                    predicate = cb.equal((Expression)lhs, rhs);
                                    break;
                                }
                                catch (IllegalAccessException ex) {
                                    logger.error((Object)ex);
                                    throw new DatabaseException(ex);
                                }
                            }
                            case NOT: {
                                predicate = cb.notEqual((Expression)lhs, rhs);
                                break;
                            }
                            case LIKE: {
                                if (!lhs.getJavaType().getSimpleName().equals("String")) break;
                                predicate = cb.like(lhs.as(String.class), "%" + (String)rhs + "%");
                                break;
                            }
                            case LESS: {
                                predicate = cb.lessThan((Expression)lhs, (Comparable)rhs);
                                break;
                            }
                            case GREATER: {
                                predicate = cb.greaterThan((Expression)lhs, (Comparable)rhs);
                                break;
                            }
                            case LESS_EQUAL: {
                                predicate = cb.lessThanOrEqualTo((Expression)lhs, (Comparable)rhs);
                                break;
                            }
                            case GREATER_EQUAL: {
                                predicate = cb.greaterThanOrEqualTo((Expression)lhs, (Comparable)rhs);
                                break;
                            }
                            case NESTED: {
                                QueryRule[] nestedrules = rule.getNestedRules();
                                predicate = JpaQueryGeneratorUtil._createWhere(db, mapper, em, root, cq, cb, new int[2], joinHash, nestedrules);
                                break;
                            }
                            case SUBQUERY: {
                                SubQueryRule sqr = (SubQueryRule)rule;
                                Subquery sq = cq.subquery(sqr.getSubQueryResultClass());
                                Root sqFrom = sq.from(sqr.getSubQueryFromClass());
                                Mapper sqMapper = db.getMapper(sqr.getSubQueryFromClass().getName());
                                Predicate where = JpaQueryGeneratorUtil._createWhere(db, sqMapper, em, sqFrom, cq, cb, new int[2], joinHash, (QueryRule[])sqr.getValue());
                                sq.select((Expression)sqFrom.get(sqr.getSubQueryAttributeJpa())).where((Expression)where);
                                String fieldForSubQuery = sqr.getJpaAttribute();
                                if (sqr.getSubQueryOperator().equals((Object)QueryRule.Operator.IN)) {
                                    predicate = cb.in((Expression)root.get(fieldForSubQuery)).value((Expression)sq);
                                    break;
                                }
                                throw new UnsupportedOperationException();
                            }
                            case IN: {
                                Object[] values = new Object[]{};
                                values = rule.getValue() instanceof List ? ((List)rule.getValue()).toArray() : (Object[])rule.getValue();
                                Class attrClass = null;
                                attrClass = attributeName.contains(".") ? lhs.getJavaType() : root.get(attributeName).getJavaType();
                                predicate = AbstractEntity.class.isAssignableFrom(attrClass) ? root.get(attributeName).in(values) : lhs.in(values);
                            }
                        }
                        if (whereClause != null) {
                            if (predicate == null) break;
                            if (prevRule != null && prevRule.getOperator().equals((Object)QueryRule.Operator.OR)) {
                                List<QueryRule> restOfQueryRules = rules.subList(i, rules.size());
                                Predicate rightsPred = JpaQueryGeneratorUtil._createWhere(db, mapper, em, root, cq, cb, limitOffset, joinHash, restOfQueryRules.toArray(new QueryRule[1]));
                                if (rightsPred == null) break block24;
                                whereClause = cb.or((Expression)whereClause, (Expression)rightsPred);
                                break block24;
                            }
                            whereClause = cb.and((Expression)whereClause, (Expression)predicate);
                            break;
                        }
                        whereClause = predicate;
                    }
                }
            }
            prevRule = rule;
        }
        if (orders.size() > 0) {
            cq.orderBy(orders);
        }
        return whereClause;
    }

    private static <E extends Entity> Expression<?> _addJoin(QueryRule rule, Root<E> root, Map<String, Join<?, ?>> joinHash) throws DatabaseException {
        try {
            String attributeName = rule.getJpaAttribute();
            if (attributeName == null) {
                return null;
            }
            if (rule.getValue() instanceof Entity) {
                return root.get(attributeName);
            }
            if (attributeName.contains(".") || root.get(attributeName).getJavaType().getName().equals("java.util.List") || root.get(attributeName).getJavaType().newInstance() instanceof Entity) {
                Entity entity = (Entity)root.getJavaType().newInstance();
                String xrefAttribtename = entity.getXrefIdFieldName(attributeName);
                String[] attributeNameSplit = StringUtils.split((String)attributeName, (String)".");
                if (attributeNameSplit.length == 0) {
                    return null;
                }
                if (attributeNameSplit.length > 1) {
                    attributeName = attributeNameSplit[0];
                    xrefAttribtename = attributeNameSplit[1];
                }
                Join join = null;
                if (joinHash.containsKey(attributeName)) {
                    join = joinHash.get(attributeName);
                } else {
                    join = root.join(attributeName, JoinType.LEFT);
                    joinHash.put(attributeName, join);
                }
                Path attribute = join.get(StringUtils.uncapitalize((String)xrefAttribtename));
                return attribute;
            }
        }
        catch (InstantiationException ex) {
        }
        catch (IllegalAccessException ex) {
            logger.error((Object)ex);
            throw new DatabaseException(ex);
        }
        return null;
    }
}

