/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.db.paging;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.paging.DatabasePager;
import org.molgenis.util.Entity;

public abstract class AbstractPager<E extends Entity>
implements DatabasePager<E> {
    private static final long serialVersionUID = -5113663340351891980L;
    private int recordID = -1;
    private Class<E> entityClass;
    private String orderByField;
    String defaultOrderByField;
    protected int limit = 10;
    private QueryRule.Operator orderByOperator = QueryRule.Operator.SORTASC;
    protected State pagingState = State.FIRST;
    protected int offset = 0;
    protected int count = 0;
    private List<QueryRule> filters = new ArrayList<QueryRule>();
    private static final Logger logger = Logger.getLogger(AbstractPager.class);
    protected List<E> page = new ArrayList();

    public AbstractPager(Class<E> entityClass, String defaultOrderByField) {
        assert (entityClass != null && defaultOrderByField != null && !defaultOrderByField.equals(""));
        this.entityClass = entityClass;
        this.orderByField = defaultOrderByField;
        this.defaultOrderByField = defaultOrderByField;
        logger.debug((Object)("created for " + entityClass.getCanonicalName() + ", ordered by " + defaultOrderByField));
    }

    @Override
    public int getCount(Database db) throws DatabaseException {
        this.refresh(db);
        return this.count;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public List<E> getPage(Database db) throws DatabaseException {
        this.refresh(db);
        return this.page;
    }

    @Override
    public List<E> first(Database db) throws DatabaseException {
        this.pagingState = State.FIRST;
        logger.debug((Object)("go to first " + this.getLimit()));
        return this.getPage(db);
    }

    @Override
    public List<E> prev(Database db) throws DatabaseException {
        this.refresh(db);
        this.pagingState = State.PREV;
        logger.debug((Object)("go to previous " + this.getLimit()));
        return this.getPage(db);
    }

    @Override
    public List<E> next(Database db) throws DatabaseException {
        this.refresh(db);
        this.pagingState = State.NEXT;
        logger.debug((Object)("go to next " + this.getLimit()));
        return this.getPage(db);
    }

    @Override
    public List<E> last(Database db) throws DatabaseException {
        this.pagingState = State.LAST;
        logger.debug((Object)("go to last " + this.getLimit()));
        return this.getPage(db);
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public void setLimit(int limit) throws DatabaseException {
        if (limit <= 0) {
            throw new IllegalArgumentException("limit must be a positive number");
        }
        if (this.limit != limit) {
            this.limit = limit;
            logger.debug((Object)("set limit to " + this.getLimit()));
            this.pagingState = State.REFRESH;
        }
    }

    @Override
    public String getOrderByField() {
        return this.orderByField;
    }

    @Override
    public void setOrderByField(String orderByField) throws DatabaseException {
        if (orderByField == null || orderByField.equals("")) {
            throw new DatabaseException("orderByField cannot be null");
        }
        this.orderByField = orderByField;
        logger.debug((Object)("set order by field to '" + orderByField + "'"));
    }

    @Override
    public QueryRule.Operator getOrderByOperator() {
        return this.orderByOperator;
    }

    @Override
    public void setOrderByOperator(QueryRule.Operator orderByOperator) throws DatabaseException {
        if (!orderByOperator.equals((Object)QueryRule.Operator.SORTASC) && !orderByOperator.equals((Object)QueryRule.Operator.SORTDESC)) {
            throw new IllegalArgumentException("orderByOperator cannot be " + (Object)((Object)orderByOperator));
        }
        this.orderByOperator = orderByOperator;
        logger.debug((Object)("set order by operator to '" + (Object)((Object)orderByOperator) + "'"));
    }

    @Override
    public void resetOrderBy() throws DatabaseException {
        this.setOrderByField(this.defaultOrderByField);
        this.setOrderByOperator(QueryRule.Operator.SORTASC);
        logger.debug((Object)("reset order by to default: field '" + this.orderByField + "', operator '" + (Object)((Object)this.orderByOperator) + "'"));
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public void setDirty(boolean dirty) {
        if (dirty) {
            this.pagingState = State.REFRESH;
        }
    }

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
        this.pagingState = State.REFRESH;
        logger.debug((Object)("changed offset to: " + offset));
    }

    @Override
    public void addFilter(QueryRule filter) throws DatabaseException {
        if (filter != null) {
            this.filters.add(filter);
            logger.debug((Object)("added filter: " + filter));
        }
    }

    @Override
    public QueryRule[] getFilters() {
        return this.filters.toArray(new QueryRule[this.filters.size()]);
    }

    @Override
    public void removeFilter(int index) throws DatabaseException {
        if (index >= 0 && index < this.filters.size()) {
            this.filters.remove(index);
            logger.debug((Object)("removed filter: " + this.filters.get(index)));
        }
    }

    @Override
    public void resetFilters() {
        this.resetFilters(new ArrayList<QueryRule>());
    }

    @Override
    public void resetFilters(List<QueryRule> filters) {
        this.filters = filters;
    }

    protected void reloadCount(Database db, QueryRule ... rules) throws DatabaseException {
        this.count = db.count(this.entityClass, rules);
    }

    protected void reloadPage(Database db, QueryRule ... rules) throws DatabaseException {
        this.setPage(db.find(this.entityClass, rules));
    }

    @Override
    public abstract void refresh(Database var1) throws DatabaseException;

    protected State getPagingState() {
        return this.pagingState;
    }

    protected void setPagingState(State pageState) {
        this.pagingState = pageState;
    }

    protected void setPage(List<E> page) {
        this.page = page;
    }

    public Class<E> getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(Class<E> entityClass) {
        this.entityClass = entityClass;
    }

    @Override
    public void setRecordId(int id) {
        this.recordID = id;
    }

    @Override
    public int getRecordId() {
        return this.recordID;
    }

    protected static enum State {
        FIRST,
        PREV,
        NEXT,
        LAST,
        UPTODATE,
        REFRESH;

    }
}

