/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.db.paging;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryImp;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.paging.AbstractPager;
import org.molgenis.util.Entity;

public class LimitOffsetPager<E extends Entity>
extends AbstractPager<E> {
    private static final long serialVersionUID = -1859965580920588085L;
    private static final Logger logger = Logger.getLogger(LimitOffsetPager.class);

    public LimitOffsetPager(Class<E> entityClass, String defaultOrderByField) throws DatabaseException {
        super(entityClass, defaultOrderByField);
        this.defaultOrderByField = defaultOrderByField;
        this.pagingState = AbstractPager.State.REFRESH;
    }

    @Override
    public void refresh(Database db) throws DatabaseException {
        if (this.pagingState == AbstractPager.State.UPTODATE) {
            return;
        }
        QueryRule[] rules = this.getFilters();
        QueryImp q = new QueryImp();
        q.addRules(rules);
        try {
            for (String fieldName : ((Entity)this.getEntityClass().newInstance()).getFields()) {
                if (!fieldName.equals("__Type")) continue;
                q.equals("__Type", this.getEntityClass().getSimpleName());
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.reloadCount(db, q.getRules());
        int oldOffset = this.offset;
        this.offset = (int)Math.floor(this.offset / this.limit) * this.limit;
        if (this.offset != oldOffset) {
            logger.warn((Object)("corrected offset from " + oldOffset + " to " + this.offset));
        }
        switch (this.pagingState) {
            case FIRST: {
                this.offset = 0;
                logger.debug((Object)("handled first, offset: " + this.offset + ", limit: " + this.limit + ", count: " + this.count));
                break;
            }
            case NEXT: {
                if (this.count > this.limit + this.offset) {
                    this.offset = this.limit + this.offset;
                }
                logger.debug((Object)("handled next, offset: " + this.offset + ", limit: " + this.limit + ", count: " + this.count));
                break;
            }
            case PREV: {
                if (this.offset - this.limit >= 0) {
                    this.offset -= this.limit;
                }
                logger.debug((Object)("handled prev, offset: " + this.offset + ", limit: " + this.limit + ", count: " + this.count));
                break;
            }
            case REFRESH: {
                if (this.count > this.offset) {
                    logger.debug((Object)("handled refresh, offset: " + this.offset + ", limit: " + this.limit + ", count: " + this.count));
                    break;
                }
                logger.debug((Object)"handled refresh, count was lower than offset so moving to show last");
            }
            case LAST: {
                this.offset = this.count > this.limit ? (int)Math.round(Math.floor((this.count - 1) / this.limit) * (double)this.limit) : 0;
                logger.debug((Object)("handled last, offset: " + this.offset + ", limit: " + this.limit + ", count: " + this.count));
            }
        }
        q.offset(this.offset);
        q.limit(this.limit);
        if (this.getOrderByField() != null) {
            if (this.getOrderByOperator().equals((Object)QueryRule.Operator.SORTASC)) {
                q.sortASC(this.getOrderByField());
            } else {
                q.sortDESC(this.getOrderByField());
            }
        }
        if (this.count > 0) {
            this.reloadPage(db, q.getRules());
        } else {
            this.setPage(new ArrayList());
        }
        logger.debug((Object)("COUNT IS " + this.count));
        this.pagingState = AbstractPager.State.UPTODATE;
    }
}

