/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.db.paging;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.paging.AbstractPager;
import org.molgenis.util.Entity;

@Deprecated
public class PrimaryKeyPager<E extends Entity>
extends AbstractPager<E> {
    private static final long serialVersionUID = 1707494068232123242L;
    private static final Logger logger = Logger.getLogger(PrimaryKeyPager.class);
    private String primaryKeyField;
    private Object nextOrderByThreshold;
    private Object prevOrderByThreshold;
    private Object nextPKeyThreshold;
    private Object prevPKeyThreshold;

    public PrimaryKeyPager(Class<E> entityClass, String primaryKeyField) throws DatabaseException {
        super(entityClass, primaryKeyField);
        this.primaryKeyField = primaryKeyField;
        this.setPagingState(AbstractPager.State.FIRST);
    }

    @Override
    public void refresh(Database db) throws DatabaseException {
        if (this.pagingState == AbstractPager.State.UPTODATE) {
            return;
        }
        ArrayList<QueryRule> rules = new ArrayList<QueryRule>();
        rules.addAll(Arrays.asList(this.getFilters()));
        logger.debug((Object)("refresh started with state '" + (Object)((Object)this.pagingState) + "'"));
        this.reloadCount(db, rules.toArray(new QueryRule[rules.size()]));
        if (this.getOrderByField() != null || "".equals(this.getOrderByField())) {
            logger.debug((Object)("adding order by on " + this.getOrderByField()));
            if (this.getOrderByOperator().equals((Object)QueryRule.Operator.SORTASC)) {
                rules.add(new QueryRule(QueryRule.Operator.SORTASC, this.getOrderByField()));
            } else {
                rules.add(new QueryRule(QueryRule.Operator.SORTDESC, this.getOrderByField()));
            }
        }
        if (!this.getOrderByField().equals(this.primaryKeyField)) {
            logger.debug((Object)("adding order by on " + this.primaryKeyField));
            if (this.getOrderByOperator().equals((Object)QueryRule.Operator.SORTASC)) {
                rules.add(new QueryRule(QueryRule.Operator.SORTASC, this.primaryKeyField));
            } else {
                rules.add(new QueryRule(QueryRule.Operator.SORTDESC, this.primaryKeyField));
            }
        }
        switch (this.pagingState) {
            case REFRESH: {
                if (this.count > this.offset) {
                    rules.add(new QueryRule(QueryRule.Operator.LIMIT, this.limit));
                    rules.add(new QueryRule(this.getOrderByField(), QueryRule.Operator.GREATER_EQUAL, this.prevOrderByThreshold));
                    if (!this.getOrderByField().equals(this.primaryKeyField)) {
                        rules.add(new QueryRule(this.primaryKeyField, QueryRule.Operator.GREATER_EQUAL, this.prevPKeyThreshold));
                    }
                    logger.debug((Object)("loaded filters for refresh. Added operator: limit=" + this.limit + ", offset=" + this.offset));
                    break;
                }
                logger.debug((Object)"refresh is delegated to 'last' operation because count < offset (maybe cause of deletes)");
                this.pagingState = AbstractPager.State.LAST;
                this.refresh(db);
                return;
            }
            case NEXT: {
                if (this.limit + this.offset < this.count) {
                    this.offset = this.limit + this.offset;
                    rules.add(new QueryRule(QueryRule.Operator.LIMIT, Math.min(this.limit, this.count - this.offset)));
                    rules.add(new QueryRule(this.getOrderByField(), QueryRule.Operator.GREATER, this.nextOrderByThreshold));
                    if (!this.getOrderByField().equals(this.primaryKeyField)) {
                        rules.add(new QueryRule(this.primaryKeyField, QueryRule.Operator.GREATER, this.nextPKeyThreshold));
                    }
                    logger.debug((Object)("loaded filters for next. Added operator: " + this.getOrderByField() + " > " + this.nextOrderByThreshold + ". Offset is: " + this.offset + ") and " + this.primaryKeyField + " greater than: " + this.nextPKeyThreshold));
                    break;
                }
                this.pagingState = AbstractPager.State.LAST;
                logger.debug((Object)("next, is already in 'last' range (offset=" + this.offset + "), refresh to last."));
                this.refresh(db);
                return;
            }
            case LAST: {
                if (this.count % this.limit != 0) {
                    rules.add(new QueryRule(QueryRule.Operator.LIMIT, this.count % this.limit));
                } else {
                    rules.add(new QueryRule(QueryRule.Operator.LIMIT, this.limit));
                }
                this.offset = this.count > this.limit ? (int)Math.round(Math.floor((this.count - 1) / this.limit) * (double)this.limit) : 0;
                rules.add(new QueryRule(QueryRule.Operator.LAST));
                logger.debug((Object)("loaded filters for last. Added operator: 'last'. Offset is: " + this.offset));
                break;
            }
            case PREV: {
                if (this.offset - this.limit >= 0) {
                    this.offset -= this.limit;
                    rules.add(new QueryRule(QueryRule.Operator.LIMIT, this.limit));
                    rules.add(new QueryRule(QueryRule.Operator.LAST));
                    rules.add(new QueryRule(this.getOrderByField(), QueryRule.Operator.LESS, this.prevOrderByThreshold));
                    if (!this.getOrderByField().equals(this.primaryKeyField)) {
                        rules.add(new QueryRule(this.primaryKeyField, QueryRule.Operator.LESS, this.prevPKeyThreshold));
                    }
                    logger.debug((Object)("prev, offset: " + this.offset + ", " + this.getOrderByField() + " < " + this.prevOrderByThreshold + " and " + this.primaryKeyField + " greater than: " + this.prevPKeyThreshold));
                    break;
                }
                logger.debug((Object)("prev, is already in 'first' range (offset=" + this.offset + "), refresh to first"));
                this.pagingState = AbstractPager.State.FIRST;
                this.refresh(db);
                return;
            }
            case FIRST: {
                this.offset = 0;
                rules.add(new QueryRule(QueryRule.Operator.LIMIT, this.limit));
                logger.debug((Object)"loaded filters for first: no filters needed");
            }
        }
        this.reloadPage(db, rules.toArray(new QueryRule[rules.size()]));
        if (this.page.size() > 0) {
            this.prevOrderByThreshold = ((Entity)this.page.get(0)).get(this.getOrderByField());
            this.prevPKeyThreshold = ((Entity)this.page.get(0)).get(this.primaryKeyField);
            this.nextOrderByThreshold = ((Entity)this.page.get(this.page.size() - 1)).get(this.getOrderByField());
            this.nextPKeyThreshold = ((Entity)this.page.get(this.page.size() - 1)).get(this.primaryKeyField);
        } else {
            logger.error((Object)"should never happen unless the db was changed between count and find");
        }
        this.pagingState = AbstractPager.State.UPTODATE;
    }
}

