/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.molgenis.framework.server.Token;

public class TokenFactory
implements Serializable {
    private static final long serialVersionUID = -1669938881359317765L;
    private final HashMap<String, Token> securityTokens = new HashMap();

    public String makeNewToken(String userName, Date validUntil) {
        String uuid = UUID.randomUUID().toString();
        Date now = new Date();
        Token newToken = new Token(userName, now, validUntil);
        this.securityTokens.put(uuid, newToken);
        this.invalidateTokens();
        return uuid;
    }

    public void removeToken(String uuid) throws Exception {
        if (!this.securityTokens.containsKey(uuid)) {
            throw new Exception("The token you requested is not available");
        }
        this.securityTokens.remove(uuid);
    }

    public List<String> getTokenIdsForUser(String userName) {
        ArrayList<String> res = new ArrayList<String>();
        for (String uuid : this.securityTokens.keySet()) {
            if (!this.securityTokens.get(uuid).getUserName().equals(userName)) continue;
            res.add(uuid);
        }
        return res;
    }

    public void invalidateTokens() {
        for (String uuid : this.securityTokens.keySet()) {
            Date now;
            Date expiresAt = this.securityTokens.get(uuid).getExpiresAt();
            if (!expiresAt.before(now = new Date())) continue;
            this.securityTokens.remove(uuid);
        }
    }

    public boolean checkIfTokenExists(String uuid) {
        return this.securityTokens.containsKey(uuid);
    }

    public Token getToken(String uuid) throws Exception {
        if (!this.securityTokens.containsKey(uuid)) {
            throw new Exception("The token you requested is not available");
        }
        return this.securityTokens.get(uuid);
    }

    public Map<String, Token> getAllTokens(String user) throws Exception {
        List<String> tokenIds = this.getTokenIdsForUser(user);
        HashMap<String, Token> tokenMap = new HashMap<String, Token>();
        for (String uuid : tokenIds) {
            Token t = this.getToken(uuid);
            tokenMap.put(uuid, t);
        }
        return tokenMap;
    }

    public void printTokens() {
        for (String uuid : this.securityTokens.keySet()) {
            String user = this.securityTokens.get(uuid).getUserName();
            String created = this.securityTokens.get(uuid).getCreatedAt().toString();
            String expires = this.securityTokens.get(uuid).getExpiresAt().toString();
            System.out.println("TOKEN: " + uuid + " for user " + user + " created at " + created + " is valid until " + expires);
        }
    }
}

