/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.tupletable;

import java.util.Iterator;
import java.util.List;
import org.molgenis.framework.tupletable.AbstractTupleTable;
import org.molgenis.framework.tupletable.TableException;
import org.molgenis.model.elements.Field;
import org.molgenis.util.tuple.Tuple;

public class TupleTableIterator
implements Iterator<Tuple> {
    private AbstractTupleTable tupleTable;
    private int row = 0;

    public TupleTableIterator(AbstractTupleTable tupleTable) throws TableException {
        this.tupleTable = tupleTable;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.tupleTable.getOffset() + this.row < this.tupleTable.getCount() && (this.tupleTable.getLimit() <= 0 || this.row < this.tupleTable.getLimit());
        }
        catch (TableException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Tuple next() {
        Tuple tuple;
        try {
            List<Field> columns = this.tupleTable.getColumns();
            if (this.tupleTable.isFirstColumnFixed()) {
                columns.add(this.tupleTable.getAllColumns().get(0));
            }
            tuple = this.tupleTable.getValues(this.tupleTable.getOffset() + this.row, columns);
        }
        catch (TableException e) {
            throw new RuntimeException(e);
        }
        ++this.row;
        return tuple;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

