/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.generators.cpp;

import freemarker.template.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.log4j.Logger;
import org.molgenis.MolgenisOptions;
import org.molgenis.generators.ForEachEntityGenerator;
import org.molgenis.generators.Generator;
import org.molgenis.generators.GeneratorHelper;
import org.molgenis.model.elements.Entity;
import org.molgenis.model.elements.Model;

public class SourcePerEntityGen
extends ForEachEntityGenerator {
    private static final Logger logger = Logger.getLogger(SourcePerEntityGen.class);

    @Override
    public String getDescription() {
        return "Generate CPP header files";
    }

    @Override
    public String getExtension() {
        return ".cpp";
    }

    @Override
    public void generate(Model model, MolgenisOptions options) throws Exception {
        if (!options.generate_tests) {
            Template template = this.createTemplate(this.getClass().getSimpleName() + this.getExtension() + ".ftl");
            Map<String, Object> templateArgs = this.createTemplateArguments(options);
            for (Entity entity : model.getEntities()) {
                String packageName = entity.getNamespace().toLowerCase() + this.getClass().getPackage().toString().substring(Generator.class.getPackage().toString().length());
                File targetDir = new File((this.getSourcePath(options).endsWith("/") ? this.getSourcePath(options) : this.getSourcePath(options) + "/") + packageName.replace(".", "/").replace("/cpp", ""));
                try {
                    File targetFile = new File(targetDir + "/" + GeneratorHelper.getJavaName(entity.getName()) + this.getExtension());
                    boolean created = targetDir.mkdirs();
                    if (!created && !targetDir.exists()) {
                        throw new IOException("could not create " + targetDir);
                    }
                    templateArgs.put("entity", entity);
                    templateArgs.put("model", model);
                    templateArgs.put("options", options);
                    templateArgs.put("template", template.getName());
                    templateArgs.put("file", targetDir.getCanonicalPath().replace("\\", "/") + "/" + GeneratorHelper.firstToUpper(entity.getName()) + this.getType() + this.getExtension());
                    templateArgs.put("package", packageName);
                    FileOutputStream targetOut = new FileOutputStream(targetFile);
                    template.process(templateArgs, (Writer)new OutputStreamWriter((OutputStream)targetOut, Charset.forName("UTF-8")));
                    ((OutputStream)targetOut).close();
                    logger.info((Object)("generated " + targetFile));
                }
                catch (Exception e) {
                    logger.error((Object)("problem generating for " + entity.getName()));
                    throw e;
                }
            }
        }
    }

    @Override
    public String getSourcePath(MolgenisOptions options) {
        return options.output_cpp;
    }
}

