/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.generators.csv;

import freemarker.template.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.molgenis.MolgenisOptions;
import org.molgenis.generators.Generator;
import org.molgenis.model.MolgenisModel;
import org.molgenis.model.elements.Entity;
import org.molgenis.model.elements.Model;

public class CsvEntityImporterGen
extends Generator {
    private static final Logger logger = Logger.getLogger(CsvEntityImporterGen.class);

    @Override
    public String getDescription() {
        return "Generates CsvEntityImporter";
    }

    @Override
    public void generate(Model model, MolgenisOptions options) throws Exception {
        if (!options.generate_tests) {
            Template template = this.createTemplate("/" + this.getClass().getSimpleName() + ".java.ftl");
            Map<String, Object> templateArgs = this.createTemplateArguments(options);
            List<Entity> entityList = model.getEntities();
            entityList = MolgenisModel.sortEntitiesByDependency(entityList, model);
            File target = new File(this.getSourcePath(options) + "org/molgenis" + "/CsvEntityImporterImpl.java");
            boolean created = target.getParentFile().mkdirs();
            if (!created && !target.getParentFile().exists()) {
                throw new IOException("could not create " + target.getParentFile());
            }
            templateArgs.put("model", model);
            templateArgs.put("entities", entityList);
            templateArgs.put("package", "org/molgenis".replace('/', '.'));
            FileOutputStream targetOut = new FileOutputStream(target);
            template.process(templateArgs, (Writer)new OutputStreamWriter((OutputStream)targetOut, Charset.forName("UTF-8")));
            ((OutputStream)targetOut).close();
            logger.info((Object)("generated " + target));
        }
    }

    @Override
    public void generate(Model model, MolgenisOptions options, String target) throws Exception {
        Template template = this.createTemplate(this.getClass().getSimpleName() + ".java.ftl");
        Map<String, Object> templateArgs = this.createTemplateArguments(options);
        List<Entity> entityList = model.getEntities();
        entityList = MolgenisModel.sortEntitiesByDependency(entityList, model);
        File generatedJavaFile = new File(target);
        boolean created = generatedJavaFile.getParentFile().mkdirs();
        if (!created && !generatedJavaFile.getParentFile().exists()) {
            throw new IOException("could not create " + generatedJavaFile.getParentFile());
        }
        templateArgs.put("model", model);
        templateArgs.put("entities", entityList);
        templateArgs.put("package", this.getClass().getPackage().getName());
        FileOutputStream targetOut = new FileOutputStream(target);
        template.process(templateArgs, (Writer)new OutputStreamWriter((OutputStream)targetOut, Charset.forName("UTF-8")));
        ((OutputStream)targetOut).close();
        logger.info((Object)("generated " + target));
    }
}

