/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.generators.db;

import freemarker.template.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import org.molgenis.MolgenisOptions;
import org.molgenis.generators.ForEachEntityGenerator;
import org.molgenis.generators.GeneratorHelper;
import org.molgenis.model.elements.Entity;
import org.molgenis.model.elements.Model;

public class MapperSecurityDecoratorGen
extends ForEachEntityGenerator {
    @Override
    public String getDescription() {
        return "(Optional) Generates an authorization decorator.";
    }

    @Override
    public String getType() {
        return "";
    }

    @Override
    public void generate(Model model, MolgenisOptions options) throws Exception {
        if (!options.generate_tests) {
            Template template = this.createTemplate(this.getClass().getSimpleName() + this.getExtension() + ".ftl");
            Map<String, Object> templateArgs = this.createTemplateArguments(options);
            for (Entity entity : model.getEntities()) {
                File targetDir;
                boolean created;
                String fullKlazzName;
                if (entity.isAbstract()) continue;
                String packageName = fullKlazzName = entity.getNamespace() + ".db." + GeneratorHelper.getJavaName(entity.getName()) + "SecurityDecorator";
                if (fullKlazzName.contains(".")) {
                    packageName = fullKlazzName.substring(0, fullKlazzName.lastIndexOf("."));
                }
                String shortKlazzName = fullKlazzName;
                if (fullKlazzName.contains(".")) {
                    shortKlazzName = fullKlazzName.substring(fullKlazzName.lastIndexOf(".") + 1);
                }
                if (!(created = (targetDir = new File(this.getSourcePath(options) + "/" + packageName.replace(".", "/"))).mkdirs()) && !targetDir.exists()) {
                    throw new IOException("could not create " + targetDir);
                }
                File targetFile = new File(targetDir + "/" + shortKlazzName + ".java");
                templateArgs.put("securityName", GeneratorHelper.getJavaName(entity.getName()).toUpperCase());
                templateArgs.put("entityClass", entity.getNamespace() + "." + GeneratorHelper.getJavaName(entity.getName()));
                templateArgs.put("clazzName", shortKlazzName);
                templateArgs.put("entity", entity);
                templateArgs.put("model", model);
                templateArgs.put("template", template.getName());
                templateArgs.put("file", packageName.replace(".", "/") + "/" + GeneratorHelper.getJavaName(entity.getName()) + this.getType() + this.getExtension());
                templateArgs.put("package", packageName);
                templateArgs.put("databaseImp", options.mapper_implementation.equals((Object)MolgenisOptions.MapperImplementation.JPA) ? "jpa" : "jdbc");
                templateArgs.remove("authorizable");
                for (Entity e : entity.getAllImplements()) {
                    if (!"Authorizable".equals(e.getName())) continue;
                    templateArgs.put("authorizable", true);
                }
                FileOutputStream targetOut = new FileOutputStream(targetFile);
                template.process(templateArgs, (Writer)new OutputStreamWriter((OutputStream)targetOut, Charset.forName("UTF-8")));
                ((OutputStream)targetOut).close();
                this.logger.info((Object)("generated " + targetFile));
            }
        }
    }
}

