/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.generators.doc;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.molgenis.MolgenisOptions;
import org.molgenis.fieldtypes.MrefField;
import org.molgenis.fieldtypes.XrefField;
import org.molgenis.generators.Generator;
import org.molgenis.model.elements.Entity;
import org.molgenis.model.elements.Field;
import org.molgenis.model.elements.Model;

public class DotDocModuleDependencyGen
extends Generator {
    private static final Logger logger = Logger.getLogger(DotDocModuleDependencyGen.class);
    public static final String GRAPHVIZ_COMMAND_WINDOWS = "dot";

    @Override
    public String getDescription() {
        return "Generates one documentation file describing all entities.";
    }

    @Override
    public void generate(Model model, MolgenisOptions options) throws Exception {
        this.generate(model, options, false);
    }

    public void generate(Model model, MolgenisOptions options, boolean wait) throws Exception {
        if (!options.generate_tests) {
            Template template = this.createTemplate("/" + this.getClass().getSimpleName() + ".java.ftl");
            Map<String, Object> templateArgs = this.createTemplateArguments(options);
            File target = new File(this.getDocumentationPath(options) + "/module-dependency-diagram.dot");
            boolean created = target.getParentFile().mkdirs();
            if (!created && !target.getParentFile().exists()) {
                throw new IOException("could not create " + target.getParentFile());
            }
            LinkedHashMap<String, Integer> mapOfRelations = new LinkedHashMap<String, Integer>();
            for (Entity e : model.getEntities()) {
                if (e.getModel() == null) continue;
                if (e.hasImplements()) {
                    for (Entity i : e.getImplements()) {
                        if (i.getModule() == null) continue;
                        this.addRule(mapOfRelations, e, i);
                    }
                }
                if (e.hasAncestor()) {
                    this.addRule(mapOfRelations, e, e.getAncestor());
                }
                for (Field f : e.getFields()) {
                    if (!(f.getType() instanceof XrefField) && !(f.getType() instanceof MrefField)) continue;
                    this.addRule(mapOfRelations, e, f.getXrefEntity());
                }
            }
            templateArgs.put("rules", mapOfRelations);
            this.apply(templateArgs, template, target);
            logger.info((Object)("generated " + target));
            this.executeDot(target, "png", wait);
        }
    }

    private void addRule(Map<String, Integer> mapOfRelations, Entity e, Entity i) {
        if (e.getModule() != null && i.getModule() != null && e.getModule() != i.getModule()) {
            String rule = "\"" + e.getModule().getName() + "\"->\"" + i.getModule().getName() + "\"";
            if (!mapOfRelations.containsKey(rule)) {
                mapOfRelations.put(rule, 0);
            }
            mapOfRelations.put(rule, mapOfRelations.get(rule) + 1);
            logger.info((Object)rule);
        }
    }

    private void apply(Map<String, Object> templateArgs, Template template, File target) throws IOException, TemplateException {
        FileOutputStream targetOut = new FileOutputStream(target);
        template.process(templateArgs, (Writer)new OutputStreamWriter((OutputStream)targetOut, Charset.forName("UTF-8")));
        ((OutputStream)targetOut).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDot(File dotFile, String type, boolean wait) {
        String command = "";
        String result = "";
        try {
            command = command + "dot -T" + type + " -O \"" + dotFile.getAbsolutePath() + "\"";
            String os = System.getProperty("os.name").toLowerCase();
            Process p = os.indexOf("windows 9") > -1 ? Runtime.getRuntime().exec(new String[]{"command.com", "/c", command}) : (os.indexOf("windows") > -1 ? Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", command}) : Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", command}));
            logger.debug((Object)("Executing: " + command));
            if (wait) {
                p.waitFor();
            }
            logger.debug((Object)("Data model image was generated succesfully.\nOutput:\n" + result));
            command = "dot -Tsvg -O \"" + dotFile.getAbsolutePath() + "\"";
            logger.debug((Object)("Executing: " + command));
            p = os.indexOf("windows 9") > -1 ? Runtime.getRuntime().exec(new String[]{"command.com", "/c", command}) : (os.indexOf("windows") > -1 ? Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", command}) : Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", command}));
            if (wait) {
                p.waitFor();
            }
            logger.debug((Object)("Data model image was generated succesfully.\nOutput:\n" + result));
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error((Object)("Generation of graphical documentation failed: return code " + e.getMessage() + ". Install GraphViz and put dot.exe on your path."));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            logger.error((Object)("Generation of graphical documentation failed: return code " + e.getMessage() + ". Install GraphViz and put dot.exe on your path."));
        }
    }
}

