/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.io;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import org.molgenis.io.TableReader;
import org.molgenis.io.TupleReader;
import org.molgenis.io.csv.CsvReader;

public class ZipTableReader
implements TableReader {
    private final ZipFile zipFile;
    private final Map<String, ZipEntry> tableNameMap;

    public ZipTableReader(ZipFile zipFile) throws IOException {
        if (zipFile == null) {
            throw new IllegalArgumentException("zip file is null");
        }
        this.zipFile = zipFile;
        this.tableNameMap = new LinkedHashMap<String, ZipEntry>();
        Enumeration<? extends ZipEntry> e = zipFile.entries();
        while (e.hasMoreElements()) {
            ZipEntry zipEntry = e.nextElement();
            int pos = zipEntry.getName().lastIndexOf(46);
            String tableName = pos != -1 ? zipEntry.getName().substring(0, pos) : zipEntry.getName();
            this.tableNameMap.put(tableName, zipEntry);
        }
    }

    @Override
    public Iterator<TupleReader> iterator() {
        return Iterators.transform(this.tableNameMap.values().iterator(), (Function)new Function<ZipEntry, TupleReader>(){

            @Nullable
            public TupleReader apply(@Nullable ZipEntry zipEntry) {
                try {
                    return ZipTableReader.this.toTupleReader(zipEntry);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public TupleReader getTupleReader(String tableName) throws IOException {
        ZipEntry zipEntry = this.tableNameMap.get(tableName);
        return zipEntry != null ? this.toTupleReader(zipEntry) : null;
    }

    @Override
    public Iterable<String> getTableNames() throws IOException {
        return this.tableNameMap.keySet();
    }

    private TupleReader toTupleReader(ZipEntry zipEntry) throws IOException {
        String name = zipEntry.getName();
        if (name.endsWith(".csv") || name.endsWith(".txt")) {
            InputStreamReader reader = new InputStreamReader(this.zipFile.getInputStream(zipEntry), Charset.forName("UTF-8"));
            return new CsvReader(reader);
        }
        if (name.endsWith(".tsv")) {
            InputStreamReader reader = new InputStreamReader(this.zipFile.getInputStream(zipEntry), Charset.forName("UTF-8"));
            return new CsvReader(reader, '\t');
        }
        throw new IOException("unknown file type: " + name);
    }
}

