/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.io.csv;

import au.com.bytecode.opencsv.CSVReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.molgenis.io.TupleReader;
import org.molgenis.io.processor.AbstractCellProcessor;
import org.molgenis.io.processor.CellProcessor;
import org.molgenis.util.tuple.Tuple;
import org.molgenis.util.tuple.ValueIndexTuple;
import org.molgenis.util.tuple.ValueTuple;

public class CsvReader
implements TupleReader {
    private static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");
    public static final char DEFAULT_SEPARATOR = ',';
    private final CSVReader csvReader;
    private final boolean hasHeader;
    private List<CellProcessor> cellProcessors;
    private Map<String, Integer> colNamesMap;

    public CsvReader(Reader reader) {
        this(reader, ',');
    }

    public CsvReader(Reader reader, char separator) {
        this(reader, separator, true);
    }

    public CsvReader(Reader reader, char separator, boolean hasHeader) {
        if (reader == null) {
            throw new IllegalArgumentException("reader is null");
        }
        this.csvReader = new CSVReader(reader, separator);
        this.hasHeader = hasHeader;
    }

    public CsvReader(File file) throws FileNotFoundException {
        this(new InputStreamReader((InputStream)new FileInputStream(file), CHARSET_UTF8));
    }

    public CsvReader(File file, char separator) throws FileNotFoundException {
        this(new InputStreamReader((InputStream)new FileInputStream(file), CHARSET_UTF8), separator);
    }

    public CsvReader(File file, char separator, boolean hasHeader) throws FileNotFoundException {
        this(new InputStreamReader((InputStream)new FileInputStream(file), CHARSET_UTF8), separator, hasHeader);
    }

    @Override
    public boolean hasColNames() {
        return this.hasHeader;
    }

    @Override
    public Iterator<String> colNamesIterator() throws IOException {
        if (!this.hasHeader) {
            return null;
        }
        if (this.colNamesMap == null) {
            this.colNamesMap = this.toColNamesMap(this.csvReader.readNext());
        }
        return this.colNamesMap != null ? this.colNamesMap.keySet().iterator() : null;
    }

    @Override
    public Iterator<Tuple> iterator() {
        try {
            final Map<String, Integer> colNamesMap = this.hasHeader ? (this.colNamesMap == null ? this.toColNamesMap(this.csvReader.readNext()) : this.colNamesMap) : null;
            return new Iterator<Tuple>(){
                private Tuple next;
                private boolean getNext = true;

                @Override
                public boolean hasNext() {
                    return this.get() != null;
                }

                @Override
                public Tuple next() {
                    Tuple tuple = this.get();
                    this.getNext = true;
                    return tuple;
                }

                private Tuple get() {
                    if (this.getNext) {
                        try {
                            String[] values = CsvReader.this.csvReader.readNext();
                            if (values != null) {
                                for (int i = 0; i < values.length; ++i) {
                                    String value = values[i].isEmpty() ? null : values[i];
                                    values[i] = CsvReader.this.processCell(value, false);
                                }
                                this.next = colNamesMap != null ? new ValueIndexTuple(colNamesMap, Arrays.asList(values)) : new ValueTuple(Arrays.asList(values));
                            } else {
                                this.next = null;
                            }
                            this.getNext = false;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return this.next;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, Integer> toColNamesMap(String[] headers) {
        if (headers == null) {
            return null;
        }
        if (headers.length == 0) {
            return Collections.emptyMap();
        }
        int capacity = (int)((double)headers.length / 0.75) + 1;
        LinkedHashMap<String, Integer> columnIdx = new LinkedHashMap<String, Integer>(capacity);
        for (int i = 0; i < headers.length; ++i) {
            String header = this.processCell(headers[i], true);
            columnIdx.put(header, i);
        }
        return columnIdx;
    }

    private String processCell(String value, boolean isHeader) {
        return AbstractCellProcessor.processCell(value, isHeader, this.cellProcessors);
    }

    @Override
    public void addCellProcessor(CellProcessor cellProcessor) {
        if (this.cellProcessors == null) {
            this.cellProcessors = new ArrayList<CellProcessor>();
        }
        this.cellProcessors.add(cellProcessor);
    }

    @Override
    public void close() throws IOException {
        this.csvReader.close();
    }
}

