/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.io.csv;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.molgenis.io.TupleWriter;
import org.molgenis.io.processor.AbstractCellProcessor;
import org.molgenis.io.processor.CellProcessor;
import org.molgenis.util.ListEscapeUtils;
import org.molgenis.util.tuple.Tuple;

public class CsvWriter
implements TupleWriter {
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    public static final char DEFAULT_SEPARATOR = ',';
    private final CSVWriter csvWriter;
    private List<CellProcessor> cellProcessors;
    private List<String> cachedColNames;

    public CsvWriter(Writer writer) {
        this(writer, ',');
    }

    public CsvWriter(Writer writer, char separator) {
        if (writer == null) {
            throw new IllegalArgumentException("writer is null");
        }
        this.csvWriter = new CSVWriter(writer, separator);
    }

    public CsvWriter(OutputStream os) {
        this(new OutputStreamWriter(os, DEFAULT_CHARSET));
    }

    public CsvWriter(OutputStream os, char separator) {
        this(new OutputStreamWriter(os, DEFAULT_CHARSET), separator);
    }

    public CsvWriter(File file) throws FileNotFoundException {
        this(new OutputStreamWriter((OutputStream)new FileOutputStream(file), DEFAULT_CHARSET), ',');
    }

    public CsvWriter(File file, char separator) throws FileNotFoundException {
        this(new OutputStreamWriter((OutputStream)new FileOutputStream(file), DEFAULT_CHARSET), separator);
    }

    @Override
    public void writeColNames(Iterable<String> colNames) throws IOException {
        if (this.cachedColNames == null) {
            ArrayList<String> processedColNames = new ArrayList<String>();
            for (String colName : colNames) {
                String processedColName = AbstractCellProcessor.processCell(colName, true, this.cellProcessors);
                processedColNames.add(processedColName);
            }
            this.csvWriter.writeNext(processedColNames.toArray(new String[0]));
            if (this.csvWriter.checkError()) {
                throw new IOException();
            }
            this.cachedColNames = processedColNames;
        }
    }

    @Override
    public void write(Tuple tuple) throws IOException {
        String[] values;
        if (this.cachedColNames != null) {
            if (!tuple.hasColNames()) {
                throw new IllegalArgumentException("tuple has no column names");
            }
            int i = 0;
            values = new String[this.cachedColNames.size()];
            for (String colName : this.cachedColNames) {
                values[i++] = this.toValue(tuple.get(colName));
            }
        } else {
            values = new String[tuple.getNrCols()];
            for (int i = 0; i < tuple.getNrCols(); ++i) {
                values[i] = this.toValue(tuple.get(i));
            }
        }
        this.csvWriter.writeNext(values);
        if (this.csvWriter.checkError()) {
            throw new IOException();
        }
    }

    @Override
    public void addCellProcessor(CellProcessor cellProcessor) {
        if (this.cellProcessors == null) {
            this.cellProcessors = new ArrayList<CellProcessor>();
        }
        this.cellProcessors.add(cellProcessor);
    }

    @Override
    public void close() throws IOException {
        this.csvWriter.close();
    }

    private String toValue(Object obj) {
        String value = obj == null ? null : (obj instanceof List ? ListEscapeUtils.toString((List)obj) : obj.toString());
        return AbstractCellProcessor.processCell(value, false, this.cellProcessors);
    }
}

