/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.model;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.log4j.Logger;
import org.molgenis.model.jaxb.Entity;
import org.molgenis.model.jaxb.Field;
import org.molgenis.model.jaxb.Model;
import org.molgenis.model.jaxb.Unique;

public class DatabaseModelExtractor {
    private static final Logger logger = Logger.getLogger(DatabaseModelExtractor.class);

    public static void main(String[] args) throws Exception {
        Properties props = new Properties();
        props.load(new FileInputStream("molgenis.properties"));
        DatabaseModelExtractor.extractXml(props);
    }

    private static String extractXml(Properties p) {
        try {
            return DatabaseModelExtractor.toString(DatabaseModelExtractor.extractModel(p));
        }
        catch (JAXBException e) {
            logger.error((Object)e);
            return null;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Model extractModel(Properties p) throws ClassNotFoundException {
        Class.forName(p.getProperty("db_driver").trim());
        String url = p.getProperty("db_uri").trim();
        String user = p.getProperty("db_user").trim();
        String password = p.getProperty("db_password").trim();
        Model m = new Model();
        try {
            int start = url.lastIndexOf("/") + 1;
            int end = url.indexOf("?") == -1 ? url.length() : url.indexOf("?");
            String SCHEMA_NAME = url.substring(start, end);
            logger.debug((Object)("trying to extract: " + SCHEMA_NAME));
            Connection conn = DriverManager.getConnection(url, user, password);
            DatabaseMetaData md = conn.getMetaData();
            m.setName(SCHEMA_NAME);
            ResultSet tableInfo = md.getTables(SCHEMA_NAME, null, null, new String[]{"TABLE"});
            while (tableInfo.next()) {
                logger.debug((Object)("TABLE: " + tableInfo));
                Entity e = new Entity();
                e.setName(tableInfo.getString("TABLE_NAME"));
                m.getEntities().add(e);
                ResultSet fieldInfo = md.getColumns(SCHEMA_NAME, null, tableInfo.getString("TABLE_NAME"), null);
                while (fieldInfo.next()) {
                    logger.debug((Object)("COLUMN: " + fieldInfo));
                    Field f = new Field();
                    f.setName(fieldInfo.getString("COLUMN_NAME"));
                    f.setType(Field.Type.getType(fieldInfo.getInt("DATA_TYPE")));
                    f.setDefaultValue(fieldInfo.getString("COLUMN_DEF"));
                    if (md.getDatabaseProductName().toLowerCase().contains("mysql") && "CURRENT_TIMESTAMP".equals(f.getDefaultValue()) && (f.getType().equals((Object)Field.Type.DATETIME) || f.getType().equals((Object)Field.Type.DATE))) {
                        f.setDefaultValue(null);
                        f.setAuto(true);
                    }
                    if (fieldInfo.getString("REMARKS") != null && !"".equals(fieldInfo.getString("REMARKS").trim())) {
                        f.setDescription(fieldInfo.getString("REMARKS"));
                    }
                    if (fieldInfo.getBoolean("NULLABLE")) {
                        f.setNillable(true);
                    }
                    if (f.getType().equals((Object)Field.Type.INT) && fieldInfo.getObject("IS_AUTOINCREMENT") != null) {
                        f.setAuto(fieldInfo.getBoolean("IS_AUTOINCREMENT"));
                    }
                    if (f.getType().equals((Object)Field.Type.STRING) || f.getType().equals((Object)Field.Type.CHAR)) {
                        if (fieldInfo.getInt("COLUMN_SIZE") > 255) {
                            f.setType(Field.Type.TEXT);
                            f.setLength(fieldInfo.getInt("COLUMN_SIZE"));
                        } else {
                            if (fieldInfo.getInt("COLUMN_SIZE") != 255) {
                                f.setLength(fieldInfo.getInt("COLUMN_SIZE"));
                            }
                            f.setType(null);
                        }
                    }
                    ResultSet xrefInfo = md.getImportedKeys(SCHEMA_NAME, null, tableInfo.getString("TABLE_NAME"));
                    while (xrefInfo.next()) {
                        if (!xrefInfo.getString("FKCOLUMN_NAME").equals(fieldInfo.getString("COLUMN_NAME"))) continue;
                        f.setType(Field.Type.XREF_SINGLE);
                        f.setXrefField(xrefInfo.getString("PKTABLE_NAME") + "." + xrefInfo.getString("PKCOLUMN_NAME"));
                    }
                    e.getFields().add(f);
                }
                Statement stmt = null;
                try {
                    String sql = "select * from " + e.getName() + " where 1=0";
                    stmt = conn.createStatement();
                    ResultSet autoincRs = stmt.executeQuery(sql);
                    ResultSetMetaData rowMeta = autoincRs.getMetaData();
                    for (int i = 1; i <= rowMeta.getColumnCount(); ++i) {
                        if (!rowMeta.isAutoIncrement(i)) continue;
                        e.getFields().get(i - 1).setAuto(true);
                    }
                }
                catch (Exception exc) {
                    logger.error((Object)("didn't retrieve autoinc/sequence: " + exc.getMessage()));
                }
                finally {
                    stmt.close();
                }
                ResultSet rsIndex = md.getIndexInfo(SCHEMA_NAME, null, tableInfo.getString("TABLE_NAME"), true, false);
                LinkedHashMap uniques = new LinkedHashMap();
                while (rsIndex.next()) {
                    logger.debug((Object)("UNIQUE: " + rsIndex));
                    if (uniques.get(rsIndex.getString("INDEX_NAME")) == null) {
                        uniques.put(rsIndex.getString("INDEX_NAME"), new ArrayList());
                    }
                    ((List)uniques.get(rsIndex.getString("INDEX_NAME"))).add(rsIndex.getString("COLUMN_NAME"));
                }
                for (List index : uniques.values()) {
                    if (index.size() == 1) {
                        e.getField((String)index.get(0)).setUnique(true);
                        continue;
                    }
                    StringBuilder fieldsBuilder = new StringBuilder();
                    for (String field_name : index) {
                        fieldsBuilder.append(',').append(field_name);
                    }
                    Unique u = new Unique();
                    u.setFields(fieldsBuilder.substring(1));
                    e.getUniques().add(u);
                }
                for (Field f : e.getFields()) {
                    if (f.getAuto() == null || !f.getAuto().booleanValue() || !f.getType().equals((Object)Field.Type.INT) || f.getUnique() == null || !f.getUnique().booleanValue()) continue;
                    f.setType(Field.Type.AUTOID);
                    f.setAuto(null);
                    f.setUnique(null);
                }
            }
            for (Entity e : m.getEntities()) {
                for (Field f : e.getFields()) {
                    if (!Field.Type.AUTOID.equals((Object)f.getType())) continue;
                    for (Entity otherE : m.getEntities()) {
                        for (Field otherF : otherE.getFields()) {
                            if (!otherF.getName().equals(f.getName()) || !otherF.getType().equals((Object)Field.Type.INT)) continue;
                            logger.debug((Object)("Guessed that " + otherE.getName() + "." + otherF.getName() + " references " + e.getName() + "." + f.getName()));
                            otherF.setType(Field.Type.XREF_SINGLE);
                            otherF.setXrefField(e.getName() + "." + f.getName());
                        }
                    }
                }
            }
            for (Entity e : m.getEntities()) {
                for (Field f : e.getFields()) {
                    if (!Field.Type.XREF_SINGLE.equals((Object)f.getType())) continue;
                    String xrefEntityName = f.getXrefField().substring(0, f.getXrefField().indexOf("."));
                    String xrefFieldName = f.getXrefField().substring(f.getXrefField().indexOf(".") + 1);
                    f.setXrefField(m.getEntity(xrefEntityName).getName() + "." + xrefFieldName);
                    for (Field labelField : m.getEntity(xrefEntityName).getFields()) {
                        if (labelField.getName().equals(xrefFieldName) || !Boolean.TRUE.equals(labelField.getUnique()) || !Boolean.FALSE.equals(labelField.getNillable())) continue;
                        logger.debug((Object)("guessed label " + e.getName() + "." + labelField.getName()));
                        f.setXrefLabel(labelField.getName());
                    }
                }
            }
            for (Entity e : m.getEntities()) {
                ArrayList<Field> toBeRemoved = new ArrayList<Field>();
                for (Field f : e.getFields()) {
                    if (!Field.Type.XREF_SINGLE.equals((Object)f.getType()) || !Boolean.TRUE.equals(f.getUnique())) continue;
                    String entityName = f.getXrefField().substring(0, f.getXrefField().indexOf("."));
                    e.setExtends(entityName);
                    toBeRemoved.add(f);
                }
                for (Field f : toBeRemoved) {
                    e.getFields().remove(f);
                }
            }
            ArrayList<Entity> toBeRemoved = new ArrayList<Entity>();
            for (Entity e : m.getEntities()) {
                if (!"".equals(e.getExtends()) || e.getFields().size() > 3) continue;
                int xrefs = 0;
                String idField = null;
                String localIdField = null;
                String localEntity = null;
                String localEntityField = null;
                String remoteIdField = null;
                String remoteEntity = null;
                String remoteEntityField = null;
                for (Field f : e.getFields()) {
                    if (Field.Type.AUTOID.equals((Object)f.getType())) {
                        idField = f.getName();
                        continue;
                    }
                    if (!Field.Type.XREF_SINGLE.equals((Object)f.getType())) continue;
                    if (++xrefs == 1) {
                        localIdField = f.getName();
                        localEntity = f.getXrefField().substring(0, f.getXrefField().indexOf("."));
                        localEntityField = f.getXrefField().substring(f.getXrefField().indexOf(".") + 1);
                        continue;
                    }
                    remoteIdField = f.getName();
                    remoteEntity = f.getXrefField().substring(0, f.getXrefField().indexOf("."));
                    remoteEntityField = f.getXrefField().substring(f.getXrefField().indexOf(".") + 1);
                }
                if (xrefs != 2 || e.getFields().size() != 2 && idField == null) continue;
                Entity localContainer = m.getEntity(localEntity);
                Field localField = new Field();
                if (localContainer.getField(e.getName()) == null) {
                    localField.setName(e.getName());
                }
                localField.setType(Field.Type.XREF_MULTIPLE);
                localField.setXrefField(remoteEntity + "." + remoteEntityField);
                localField.setMrefName(e.getName());
                localField.setMrefLocalid(localIdField);
                localField.setMrefRemoteid(remoteIdField);
                localContainer.getFields().add(localField);
                Entity remoteContainer = m.getEntity(remoteEntity);
                Field remoteField = new Field();
                remoteField.setType(Field.Type.XREF_MULTIPLE);
                remoteField.setXrefField(localEntity + "." + localEntityField);
                remoteField.setMrefName(e.getName());
                remoteField.setMrefLocalid(remoteIdField);
                remoteField.setMrefRemoteid(localIdField);
                if (remoteContainer.getField(e.getName()) != null) {
                    throw new RuntimeException("MREF creation failed: there is already a field " + remoteContainer.getName() + "." + e.getName());
                }
                remoteField.setName(e.getName());
                remoteContainer.getFields().add(remoteField);
                toBeRemoved.add(e);
                logger.debug((Object)("guessed mref " + e.getName()));
            }
            m.getEntities().removeAll(toBeRemoved);
            logger.info((Object)DatabaseModelExtractor.toString(m));
            return m;
        }
        catch (SQLException e) {
            logger.error((Object)e);
            e.printStackTrace();
            return null;
        }
        catch (JAXBException e1) {
            logger.error((Object)e1);
            e1.printStackTrace();
            return null;
        }
    }

    private static String toString(Model model) throws JAXBException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.molgenis.model.jaxb");
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        marshaller.marshal((Object)model, (OutputStream)out);
        try {
            return out.toString("UTF-8").trim();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

