/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.model.elements;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Vector;
import org.molgenis.model.elements.Form;
import org.molgenis.model.elements.Menu;
import org.molgenis.model.elements.Plugin;
import org.molgenis.model.elements.Tree;
import org.molgenis.util.SimpleTree;

public class UISchema
extends SimpleTree<UISchema> {
    private static final long serialVersionUID = 1816308705758091632L;
    private String label;
    private String namespace;
    private String group;
    private String groupRead;

    public UISchema(String name, UISchema parent) {
        super(name, parent);
    }

    public String getPathName() {
        String path = this.getPackageName() + "/";
        return path.replace('.', '/');
    }

    public String getPackageName() {
        return "";
    }

    public String getClassName() {
        String name = this.getName();
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return name;
        }
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public String getCanonicalClassName() {
        return this.getClassName().substring(0, 1).toUpperCase();
    }

    public String getVelocityName() {
        return this.getName().replace('.', '_');
    }

    public List<UISchema> getCompleteSchema() {
        Vector<UISchema> results = new Vector<UISchema>();
        Vector children = this.getChildren();
        for (UISchema child : children) {
            results.add(child);
            results.addAll(child.getCompleteSchema());
        }
        return results;
    }

    public List<Menu> getMenus() {
        Vector<Menu> menus = new Vector<Menu>();
        for (UISchema element : this.getChildren()) {
            if (!element.getClass().equals(Menu.class)) continue;
            menus.add((Menu)element);
        }
        return menus;
    }

    public ArrayList<String> getAllUniqueGroups() {
        LinkedHashSet<String> uniqueGroups = new LinkedHashSet<String>();
        for (UISchema schema : this.getAllChildren()) {
            String groupReadStr;
            String groupStr = schema.getGroup();
            if (groupStr != null) {
                for (String group : groupStr.split(",")) {
                    if ((group = group.trim()).isEmpty()) continue;
                    uniqueGroups.add(group);
                }
            }
            if ((groupReadStr = schema.getGroupRead()) == null) continue;
            for (String group : groupReadStr.split(",")) {
                if ((group = group.trim()).isEmpty()) continue;
                uniqueGroups.add(group);
            }
        }
        return new ArrayList<String>(uniqueGroups);
    }

    public List<Form> getAllForms() {
        ArrayList<Form> forms = new ArrayList<Form>();
        for (UISchema element : this.getAllChildren()) {
            if (!element.getClass().equals(Form.class)) continue;
            forms.add((Form)element);
        }
        return forms;
    }

    public List<Form> getForms() {
        Vector<Form> forms = new Vector<Form>();
        for (UISchema element : this.getChildren()) {
            if (!element.getClass().equals(Form.class)) continue;
            forms.add((Form)element);
        }
        return forms;
    }

    public Vector<Tree> getTrees() {
        Vector<Tree> trees = new Vector<Tree>();
        for (UISchema child : this.getChildren()) {
            if (!child.getClass().equals(Tree.class)) continue;
            trees.add((Tree)child);
        }
        return trees;
    }

    public Vector<Plugin> getPlugins() {
        Vector<Plugin> plugins = new Vector<Plugin>();
        for (UISchema child : this.getChildren()) {
            if (!child.getClass().equals(Plugin.class)) continue;
            plugins.add((Plugin)child);
        }
        return plugins;
    }

    public Type getType() {
        return Type.UNKNOWN;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getGroupRead() {
        return this.groupRead;
    }

    public void setGroupRead(String groupRead) {
        this.groupRead = groupRead;
    }

    static enum Type {
        UNKNOWN,
        FORM,
        TREE,
        MENU,
        PLUGIN;

    }
}

