/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.services.pubmed;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.molgenis.services.pubmed.Article;
import org.molgenis.services.pubmed.Author;
import org.molgenis.services.pubmed.MeshHeading;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class MedlineCitation {
    @XmlElement
    public String PMID;
    @XmlElement(name="Article")
    public Article article;
    @XmlElementWrapper(name="MeshHeadingList")
    @XmlElement(name="MeshHeading")
    public List<MeshHeading> MeshHeadings = new ArrayList<MeshHeading>();
    public List<Author> authors = new ArrayList<Author>();

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("pmid=").append(this.PMID);
        if (this.article != null) {
            strBuilder.append(", title=").append(this.article.ArticleTitle);
            if (this.article.Journal != null) {
                strBuilder.append(", journal=").append(this.article.Journal.Title);
                if (this.article.Journal.JournalIssue != null) {
                    strBuilder.append(", volume=").append(this.article.Journal.JournalIssue.Volume);
                    strBuilder.append(", issue=").append(this.article.Journal.JournalIssue.Issue);
                    if (this.article.Journal.JournalIssue.PubDate != null) {
                        strBuilder.append(", year=").append(this.article.Journal.JournalIssue.PubDate.Year);
                        strBuilder.append(", month=").append(this.article.Journal.JournalIssue.PubDate.Month);
                    }
                }
            }
            for (Author au : this.article.Authors) {
                strBuilder.append('\n').append(au.toString());
            }
            if (this.article.Abstract != null) {
                strBuilder.append("\nabstract=").append(this.article.Abstract.AbstractText);
            }
        }
        for (MeshHeading mesh : this.MeshHeadings) {
            strBuilder.append("\nmesh=").append(mesh.DescriptorName);
        }
        return strBuilder.toString();
    }
}

