/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.apache.log4j.Logger;
import org.molgenis.util.ImageResizer;

public class ImageMagickResizer
implements ImageResizer {
    private static final Logger logger = Logger.getLogger(ImageMagickResizer.class);
    public static final String IMAGEMAGICK_COMMAND = "C:/Program Files/ImageMagick-6.5.4-Q16/convert";

    @Override
    public boolean resize(File src, File dest, int destWidth, int destHeight) throws Exception {
        String command = "C:/Program Files/ImageMagick-6.5.4-Q16/convert -resize %sx%s -quality 75 \"%s\" \"%s\"";
        command = String.format(command, destWidth, destHeight, src.getAbsolutePath(), dest.getAbsolutePath());
        logger.debug((Object)("Executing ImageMagick: " + command));
        try {
            Process process = Runtime.getRuntime().exec(command);
            process.waitFor();
            String error = this.streamToString(process.getErrorStream());
            if (error.length() > 0) {
                logger.error((Object)("ImageMagick printed errors: " + error));
                return false;
            }
            String output = this.streamToString(process.getInputStream());
            if (error.length() > 0) {
                logger.debug((Object)("ImageMagick printed messages: " + output));
                return false;
            }
            if (process.exitValue() > 0) {
                throw new Exception("" + process.exitValue());
            }
            return true;
        }
        catch (IOException e) {
            logger.error((Object)("IOException while trying to execute " + command));
            return false;
        }
    }

    private String streamToString(InputStream inputStream) throws IOException {
        String line;
        StringBuffer fileContents = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, Charset.forName("UTF-8")));
        while ((line = reader.readLine()) != null) {
            fileContents.append(line + "\n");
        }
        reader.close();
        inputStream.close();
        return fileContents.toString();
    }
}

