/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.util.cmdline;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Level;
import org.molgenis.util.cmdline.CmdLineException;
import org.molgenis.util.cmdline.Option;
import org.molgenis.util.cmdline.OptionsClass;

public class CmdLineParser {
    private Object options;
    private HashMap<String, Field> field_map;
    private HashMap<String, Method> method_map;
    private String description = null;

    public CmdLineParser(Object options) throws NullPointerException, CmdLineException {
        if (options == null) {
            throw new CmdLineException("The parameters options and/or description cannot be null.");
        }
        this.options = options;
        this.field_map = new HashMap();
        this.method_map = new HashMap();
        Field[] fields = options.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].isAnnotationPresent(Option.class)) continue;
            Option opt = fields[i].getAnnotation(Option.class);
            this.field_map.put(opt.name(), fields[i]);
        }
        Method[] methods = options.getClass().getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].isAnnotationPresent(Option.class)) continue;
            Option opt = methods[i].getAnnotation(Option.class);
            this.method_map.put(opt.name(), methods[i]);
        }
        OptionsClass optionscls = options.getClass().getAnnotation(OptionsClass.class);
        if (optionscls != null) {
            this.description = optionscls.description();
        }
    }

    public void parse(String[] args) throws CmdLineException {
        Field prevfield = null;
        for (int i = 0; i < args.length; ++i) {
            Field field;
            String name = args[i];
            if ((name = name.trim()).charAt(0) == '-') {
                name = name.substring(1);
            }
            if ((field = this.field_map.get(name)) == null) {
                --i;
                field = prevfield;
            }
            if (field != null) {
                Option opt = field.getAnnotation(Option.class);
                try {
                    String nxt_option;
                    String result = "";
                    if (opt.type() == Option.Type.NO_ARGUMENT) {
                        result = "true";
                    } else if (opt.type() == Option.Type.OPTIONAL_ARGUMENT) {
                        if (i + 1 >= args.length) {
                            result = "true";
                        } else if ((nxt_option = args[++i]).charAt(0) != '-') {
                            result = nxt_option;
                        }
                    } else {
                        if (i + 1 >= args.length) {
                            throw new CmdLineException("Insufficient number of options.");
                        }
                        result = nxt_option = args[++i];
                    }
                    this.assign(opt, result, field);
                }
                catch (Exception e) {
                    throw new CmdLineException("Unhandled situation:\n" + e.toString());
                }
            }
            prevfield = field;
        }
    }

    private void assign(Option opt, String result, Field field) throws CmdLineException {
        if (!this.assignToField(opt, result, field)) {
            if (opt.type() == Option.Type.REQUIRED_ARGUMENT) {
                throw new CmdLineException("Error in REQUIRED_ARGUMENT: " + opt.toString() + " for value: " + result);
            }
            System.err.println("Error in OPTIONAL_ARGUMENT: " + opt.toString() + " for value: " + result);
            System.err.println("Sleeping for 5 secs..");
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    private boolean assignToField(Option opt, String result, Field field) throws CmdLineException {
        try {
            switch (opt.param()) {
                case BOOLEAN: {
                    field.set(this.options, Boolean.parseBoolean(result));
                    break;
                }
                case INTEGER: {
                    field.set(this.options, Integer.parseInt(result));
                    break;
                }
                case DOUBLE: {
                    field.set(this.options, Double.parseDouble(result));
                    break;
                }
                case STRING: {
                    field.set(this.options, result);
                    break;
                }
                case COLLECTION: {
                    ArrayList collection = (ArrayList)field.get(this.options);
                    for (String v : result.toString().split(",")) {
                        collection.add(v);
                    }
                    break;
                }
                case FILEPATH: {
                    field.set(this.options, result);
                    break;
                }
                case DIRPATH: {
                    field.set(this.options, result.endsWith("/") ? result : result + "/");
                    break;
                }
                case PASSWORD: {
                    field.set(this.options, result);
                    break;
                }
                case CLASS: {
                    field.set(this.options, result);
                    break;
                }
                case ENUM: {
                    System.out.println(field);
                    field.set(this.options, Enum.valueOf(field.getType(), result));
                    break;
                }
                case LOG4JLEVEL: {
                    field.set(this.options, Level.toLevel((String)result));
                    break;
                }
                default: {
                    field.set(this.options, result);
                }
            }
        }
        catch (IllegalAccessException ex) {
            throw new CmdLineException("Bad cast when trying to read options:\n" + ex.toString());
        }
        return true;
    }

    public void parse(Properties properties) throws CmdLineException {
        for (Map.Entry<Object, Object> property : properties.entrySet()) {
            Field field;
            String name = property.getKey().toString();
            if (name.charAt(0) == '-') {
                name = name.substring(1);
            }
            if ((field = this.field_map.get(name)) == null) continue;
            Option opt = field.getAnnotation(Option.class);
            String result = "";
            if (opt.type() == Option.Type.NO_ARGUMENT) {
                result = "true";
            } else if (opt.type() == Option.Type.OPTIONAL_ARGUMENT) {
                result = property.getValue().toString().trim();
            } else if (opt.type() == Option.Type.REQUIRED_ARGUMENT) {
                if (property.getValue().toString().length() == 0) {
                    throw new CmdLineException("Insufficient number of options.");
                }
                result = property.getValue().toString().trim();
            }
            this.assign(opt, result, field);
        }
    }

    public void printOptions() {
        Option option;
        Field field;
        Iterator<Field> it_field = this.field_map.values().iterator();
        int namesize = 0;
        while (it_field.hasNext()) {
            field = it_field.next();
            option = field.getAnnotation(Option.class);
            namesize = Math.max(namesize, option.name().length());
        }
        it_field = this.field_map.values().iterator();
        System.out.println("Options {");
        while (it_field.hasNext()) {
            field = it_field.next();
            option = field.getAnnotation(Option.class);
            try {
                System.out.print("  " + option.name() + ": ");
                for (int i = 0; i < namesize - option.name().length(); ++i) {
                    System.out.print(" ");
                }
                System.out.println(field.get(this.options));
            }
            catch (IllegalAccessException e) {
                System.out.println("[failed]");
            }
        }
        System.out.println("}");
    }

    public void printUsage(PrintStream stream, String msg) {
        Option option;
        int width = 80;
        if (msg != null && msg.length() != 0) {
            stream.print(msg + "\n\n");
        }
        if (this.description != null && this.description.length() != 0) {
            int endindex;
            for (int index = 0; index < this.description.length(); index += endindex + 1) {
                if (index + 80 < this.description.length()) {
                    String str = this.description.substring(index, index + 80);
                    endindex = str.lastIndexOf(10);
                    if (endindex == -1) {
                        endindex = str.lastIndexOf(32);
                    }
                    if (endindex == -1 || endindex > 80) {
                        endindex = 80;
                    }
                    stream.println(str.substring(0, endindex));
                    continue;
                }
                stream.println(this.description.substring(index));
                break;
            }
        }
        stream.print("\nUsage:\n");
        int taglength = 0;
        for (Field field : this.field_map.values()) {
            option = field.getAnnotation(Option.class);
            taglength = Math.max(taglength, option.name().length() + 2);
        }
        for (Field field : this.field_map.values()) {
            String[] usages;
            option = field.getAnnotation(Option.class);
            char tagopen = '<';
            char tagclose = '>';
            try {
                if (Collection.class.isInstance(field.getType().newInstance())) {
                    tagopen = '[';
                    tagclose = ']';
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            stream.print(option.name());
            if (option.type() != Option.Type.NO_ARGUMENT) {
                for (int i = 0; i < taglength - option.name().length(); ++i) {
                    stream.print(' ');
                }
                stream.println(tagopen + option.param().toString() + tagclose);
            } else {
                stream.println();
            }
            block6: for (String usage : usages = option.usage().split("\n")) {
                int endindex;
                for (int index = 0; index < usage.length(); index += endindex + 1) {
                    for (int i = 0; i < taglength; ++i) {
                        stream.print(' ');
                    }
                    if (index + 80 - taglength < usage.length()) {
                        String str = usage.substring(index, index + 80 - taglength);
                        endindex = str.lastIndexOf(10);
                        if (endindex == -1) {
                            endindex = str.lastIndexOf(32);
                        }
                        if (endindex == -1 || endindex > 80 - taglength) {
                            endindex = 80 - taglength;
                        }
                        stream.println(str.substring(0, endindex));
                        continue;
                    }
                    stream.println(usage.substring(index));
                    continue block6;
                }
            }
        }
    }

    public String toString(Object options) throws CmdLineException {
        String value;
        Option opt;
        int i;
        StringBuffer result = new StringBuffer();
        Field[] fields = options.getClass().getDeclaredFields();
        int name_padding = 0;
        int value_padding = 0;
        for (i = 0; i < fields.length; ++i) {
            if (!fields[i].isAnnotationPresent(Option.class)) continue;
            opt = fields[i].getAnnotation(Option.class);
            name_padding = Math.max(name_padding, fields[i].getAnnotation(Option.class).name().length());
            try {
                value = fields[i].get(options).toString();
                if (opt.param() == Option.Param.PASSWORD) {
                    value = "xxxxxx";
                }
                value_padding = Math.max(value_padding, value.length());
                continue;
            }
            catch (IllegalAccessException e) {
                throw new CmdLineException("faulty option field " + fields[i]);
            }
        }
        for (i = 0; i < fields.length; ++i) {
            if (!fields[i].isAnnotationPresent(Option.class)) continue;
            opt = fields[i].getAnnotation(Option.class);
            try {
                value = fields[i].get(options).toString();
                if (opt.param().equals((Object)Option.Param.PASSWORD)) {
                    value = "xxxxxx";
                }
                StringBuilder n_spacesBuilder = new StringBuilder();
                for (int j = opt.name().length(); j < name_padding; ++j) {
                    n_spacesBuilder.append(' ');
                }
                StringBuilder v_spacesBuilder = new StringBuilder();
                for (int j = value.length(); j < value_padding; ++j) {
                    v_spacesBuilder.append(' ');
                }
                result.append(opt.name() + n_spacesBuilder.toString() + " = " + value + v_spacesBuilder.toString() + " #" + opt.usage() + "\n");
                continue;
            }
            catch (IllegalAccessException e) {
                throw new CmdLineException("faulty option field " + fields[i]);
            }
        }
        return result.toString();
    }
}

