/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.util.tuple;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.molgenis.util.tuple.AbstractTuple;
import org.molgenis.util.tuple.Tuple;
import org.molgenis.util.tuple.WritableTuple;

public class KeyValueTuple
extends AbstractTuple
implements WritableTuple {
    private static final long serialVersionUID = 1L;
    private final Map<String, Object> valueMap = new LinkedHashMap<String, Object>();

    public KeyValueTuple() {
    }

    public KeyValueTuple(Tuple t) {
        this();
        this.set(t);
    }

    @Override
    public int getNrCols() {
        return this.valueMap.size();
    }

    @Override
    public Iterable<String> getColNames() {
        return Collections.unmodifiableSet(this.valueMap.keySet());
    }

    @Override
    public Object get(String colName) {
        return this.valueMap.get(colName);
    }

    @Override
    public Object get(int col) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(String colName, Object val) {
        this.valueMap.put(colName, val);
    }

    @Override
    public void set(Tuple t) {
        for (String col : t.getColNames()) {
            this.set(col, t.get(col));
        }
    }

    @Override
    public void remove(String colName) {
        this.valueMap.remove(colName);
    }
}

