/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.util.tuple;

import java.util.Collections;
import org.molgenis.util.tuple.AbstractTuple;

public class SingletonTuple<T>
extends AbstractTuple {
    private static final long serialVersionUID = 1L;
    private final String colName;
    private final T value;

    public SingletonTuple(String colName, T value) {
        if (colName == null) {
            throw new IllegalArgumentException("col name is null");
        }
        this.colName = colName;
        this.value = value;
    }

    @Override
    public int getNrCols() {
        return 1;
    }

    @Override
    public Iterable<String> getColNames() {
        return Collections.singletonList(this.colName);
    }

    @Override
    public Object get(String colName) {
        return this.colName.equals(colName) ? this.value : null;
    }

    @Override
    public Object get(int col) {
        throw new UnsupportedOperationException();
    }
}

