package org.molgenis.framework.db;

import java.text.ParseException;
import java.util.List;

import org.molgenis.fieldtypes.FieldType;
import org.molgenis.util.Entity;

/**
 * Interface for the Molgenis mappers. Mappers are an intermediate between Molgenis and the database and provide many
 * useful helper methods.
 */
public interface Mapper<E extends Entity>
{
	/**
	 * Get the database this mapper is attached to.
	 * 
	 * @return database
	 */
	public Database getDatabase();

	// TODO add "throws DatabaseException" to method signature
	public E create();

	/** Implementation of {@link Database#count(Class, QueryRule...)} */
	public int count(QueryRule... rules) throws DatabaseException;

	/** Implementation of {@link Database#find(Class, QueryRule...)} */
	public List<E> find(QueryRule... rules) throws DatabaseException;

	/** Implementation of {@link Database#add(Entity)} */
	// public int add(E entity) throws DatabaseException;

	/** Implementation of {@link Database#add(List)} */
	public int add(List<E> entities) throws DatabaseException;

	/** Implementation of {@link Database#add(Entity)} */
	// public int update(E entity) throws DatabaseException;

	/** Implementation of {@link Database#update(List)} */
	public int update(List<E> entities) throws DatabaseException;

	/** Implementation of {@link Database#remove(List)} */
	public int remove(List<E> entities) throws DatabaseException;

	public String getTableFieldName(String field);

	public FieldType getFieldType(String field);

	public void resolveForeignKeys(List<E> entities) throws ParseException, DatabaseException;

	public String createFindSqlInclRules(QueryRule[] rules) throws DatabaseException;

	public E findById(Object id) throws DatabaseException;

	int executeAdd(List<? extends E> entities) throws DatabaseException;

	int executeUpdate(List<? extends E> entities) throws DatabaseException;

	int executeRemove(List<? extends E> entities) throws DatabaseException;

	// TODO add "throws DatabaseException" to method signature
	/**
	 * Return EMPTY list of given allocated size
	 * 
	 * @param i
	 *            initial capacity of returned EMPTY list
	 * @return an EMPTY list with initial capacity given by size
	 */
	public List<E> createList(int i);
}
