/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallCert {
    private static final Logger LOG = LoggerFactory.getLogger(InstallCert.class);
    private static final char[] HEXDIGITS = "0123456789abcdef".toCharArray();

    public static void main(String[] args) throws Exception {
        int k;
        if (args.length != 1 && args.length != 2) {
            LOG.debug("Usage: java InstallCert <host>[:port] [passphrase]");
            return;
        }
        String[] c = args[0].split(":");
        String host = c[0];
        int port = c.length == 1 ? 443 : Integer.parseInt(c[1]);
        String p = args.length == 1 ? "changeit" : args[1];
        char[] passphrase = p.toCharArray();
        File file = new File("jssecacerts");
        if (!file.isFile()) {
            char SEP = File.separatorChar;
            File dir = new File(System.getProperty("java.home") + SEP + "lib" + SEP + "security");
            file = new File(dir, "jssecacerts");
            if (!file.isFile()) {
                file = new File(dir, "cacerts");
            }
        }
        LOG.info("Loading KeyStore " + file + "...");
        FileInputStream in = new FileInputStream(file);
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(in, passphrase);
        ((InputStream)in).close();
        SSLContext context = SSLContext.getInstance("TLS");
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ks);
        X509TrustManager defaultTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
        SavingTrustManager tm = new SavingTrustManager(defaultTrustManager);
        context.init(null, new TrustManager[]{tm}, null);
        SSLSocketFactory factory = context.getSocketFactory();
        LOG.info("Opening connection to " + host + ":" + port + "...");
        SSLSocket socket = (SSLSocket)factory.createSocket(host, port);
        socket.setSoTimeout(10000);
        try {
            LOG.info("Starting SSL handshake...");
            socket.startHandshake();
            socket.close();
            LOG.info("No errors, certificate is already trusted");
        }
        catch (SSLException e) {
            e.printStackTrace(System.out);
        }
        X509Certificate[] chain = tm.chain;
        if (chain == null) {
            LOG.error("Could not obtain server certificate chain");
            return;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in, Charset.forName("UTF-8")));
        LOG.info("Server sent " + chain.length + " certificate(s):");
        MessageDigest sha1 = MessageDigest.getInstance("SHA1");
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        for (int i = 0; i < chain.length; ++i) {
            X509Certificate cert = chain[i];
            LOG.info(" " + (i + 1) + " Subject " + cert.getSubjectDN());
            LOG.info("   Issuer  " + cert.getIssuerDN());
            sha1.update(cert.getEncoded());
            LOG.info("   sha1    " + InstallCert.toHexString(sha1.digest()));
            md5.update(cert.getEncoded());
            LOG.info("   md5     " + InstallCert.toHexString(md5.digest()));
        }
        LOG.info("Enter certificate to add to trusted keystore or 'q' to quit: [1]");
        String line = reader.readLine();
        if (line == null) {
            throw new RuntimeException("unexpected end of stream");
        }
        line = line.trim();
        try {
            k = line.length() == 0 ? 0 : Integer.parseInt(line) - 1;
        }
        catch (NumberFormatException e) {
            LOG.info("KeyStore not changed");
            return;
        }
        X509Certificate cert = chain[k];
        String alias = host + "-" + (k + 1);
        ks.setCertificateEntry(alias, cert);
        FileOutputStream out = new FileOutputStream("jssecacerts");
        ks.store(out, passphrase);
        ((OutputStream)out).close();
        LOG.info(cert.toString());
        LOG.info("Added certificate to keystore 'jssecacerts' using alias '" + alias + "'");
    }

    private static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 3);
        for (int n : bytes) {
            sb.append(HEXDIGITS[(n &= 0xFF) >> 4]);
            sb.append(HEXDIGITS[n & 0xF]);
            sb.append(' ');
        }
        return sb.toString();
    }

    private static class SavingTrustManager
    implements X509TrustManager {
        private final X509TrustManager tm;
        private X509Certificate[] chain;

        SavingTrustManager(X509TrustManager tm) {
            this.tm = tm;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.chain = chain;
            this.tm.checkServerTrusted(chain, authType);
        }
    }
}

