package org.molgenis.generators.db;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.molgenis.MolgenisOptions;
import org.molgenis.generators.Generator;
import org.molgenis.model.MolgenisModel;
import org.molgenis.model.elements.Entity;
import org.molgenis.model.elements.Model;

import freemarker.template.Template;

public class EntitiesValidatorGen extends Generator
{
	private static final Logger LOG = LoggerFactory.getLogger(EntitiesValidatorGen.class);

	@Override
	public String getDescription()
	{
		return "Generates a prognosis report maker for the generic data import wizard using Excel files";
	}

	@Override
	public void generate(Model model, MolgenisOptions options) throws Exception
	{
		if (options.generate_tests)
		{
		}
		else
		{
			Template template = createTemplate("/" + this.getClass().getSimpleName() + ".java.ftl");
			Map<String, Object> templateArgs = createTemplateArguments(options);

			List<Entity> entityList = model.getEntities();
			entityList = MolgenisModel.sortEntitiesByDependency(entityList, model); // side
																					// effect?

			File target = new File(this.getSourcePath(options) + APP_DIR + "/EntitiesValidatorImpl.java");
			boolean created = target.getParentFile().mkdirs();
			if (!created && !target.getParentFile().exists())
			{
				throw new IOException("could not create " + target.getParentFile());
			}

			templateArgs.put("model", model);
			templateArgs.put("entities", entityList);
			templateArgs.put("package", APP_DIR.replace('/', '.'));
			OutputStream targetOut = new FileOutputStream(target);
			template.process(templateArgs, new OutputStreamWriter(targetOut, Charset.forName("UTF-8")));
			targetOut.close();

			LOG.info("generated " + target);
		}
	}
}
