/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.model.elements;

import java.io.Serializable;
import java.util.List;
import org.molgenis.model.MolgenisModelException;
import org.molgenis.model.elements.Method;

public class Parameter
implements Serializable {
    public static final int LENGTH_NOT_SET = 0;
    private Method parent;
    private Type type;
    private String name;
    private String label;
    private boolean nillable;
    private String default_value;
    private String description;
    private List<String> enum_options;
    private int varchar_length;
    private Object user_data;
    private static final long serialVersionUID = -1879739243713730190L;

    public Parameter(Method parent, Type type) {
        this(parent, type, null, null, false, null);
    }

    public Parameter(Method parent, Type type, String name, String label, boolean nillable, String default_value) {
        this.parent = parent;
        this.type = type;
        this.name = name;
        this.label = label;
        this.nillable = nillable;
        this.default_value = default_value;
        this.description = "";
        if (this.label == null || this.label.isEmpty()) {
            this.label = this.name;
        }
        this.varchar_length = 0;
        this.user_data = null;
    }

    @Deprecated
    public Method getParent() {
        return this.parent;
    }

    public Method getEntity() {
        return this.parent;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isNillable() {
        return this.nillable;
    }

    public String getDefaultValue() {
        return this.default_value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setEnumOptions(List<String> options) throws MolgenisModelException {
        if (this.type != Type.ENUM) {
            throw new MolgenisModelException("Field is not a ENUM, so options cannot be set.");
        }
        if (options.size() == 0) {
            throw new MolgenisModelException("Enum must have at least one option");
        }
        this.enum_options = options;
    }

    public List<String> getEnumOptions() throws MolgenisModelException {
        if (this.type != Type.ENUM) {
            throw new MolgenisModelException("Field is not a ENUM, so options cannot be set.");
        }
        return this.enum_options;
    }

    public void setVarCharLength(int length) throws Exception {
        if (this.type != Type.VARCHAR) {
            throw new Exception("Field is not a VARCHAR, so length cannot be set.");
        }
        this.varchar_length = length;
    }

    public int getVarCharLength() throws Exception {
        if (this.type != Type.VARCHAR) {
            throw new Exception("Field is not a VARCHAR, so length cannot be retrieved.");
        }
        return this.varchar_length;
    }

    public void setUserData(Object obj) {
        this.user_data = obj;
    }

    public Object getUserData() {
        return this.user_data;
    }

    public String toString() {
        String str = "Parameter(";
        str = str + this.name;
        str = str + ", " + this.type.tag;
        if (this.type == Type.VARCHAR) {
            str = str + "[" + this.varchar_length + "]";
        }
        str = str + ", nillable=" + this.nillable;
        str = str + ", default=" + this.default_value;
        str = str + ")";
        return str;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Parameter) {
            return this.name.equals(((Parameter)obj).getName());
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static enum Type {
        UNKNOWN("unknown"),
        BOOL("bool"),
        INT("int"),
        DECIMAL("decimal"),
        VARCHAR("varchar"),
        TEXT("text"),
        DATE("date"),
        DATETIME("datetime"),
        USER("user"),
        FILE("file"),
        ENUM("enum");

        public final String tag;

        private Type(String tag) {
            this.tag = tag;
        }

        public static Type getType(String tag) {
            if (tag.equals(Type.BOOL.tag)) {
                return BOOL;
            }
            if (tag.equals(Type.INT.tag)) {
                return INT;
            }
            if (tag.equals(Type.DECIMAL.tag)) {
                return DECIMAL;
            }
            if (tag.equals(Type.VARCHAR.tag)) {
                return VARCHAR;
            }
            if (tag.equals(Type.TEXT.tag)) {
                return TEXT;
            }
            if (tag.equals(Type.DATE.tag)) {
                return DATE;
            }
            if (tag.equals(Type.DATETIME.tag)) {
                return DATETIME;
            }
            if (tag.equals(Type.USER.tag)) {
                return USER;
            }
            if (tag.equals(Type.FILE.tag)) {
                return FILE;
            }
            if (tag.equals(Type.ENUM.tag)) {
                return ENUM;
            }
            return UNKNOWN;
        }
    }
}

