/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.generators;

import freemarker.template.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import org.molgenis.MolgenisOptions;
import org.molgenis.generators.Generator;
import org.molgenis.generators.GeneratorHelper;
import org.molgenis.model.elements.Entity;
import org.molgenis.model.elements.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ForEachEntityGenerator
extends Generator {
    protected static final Logger LOG = LoggerFactory.getLogger(ForEachEntityGenerator.class);
    private boolean includeAbstract = false;
    private boolean handwritten = false;

    public ForEachEntityGenerator() {
        this(false);
    }

    public ForEachEntityGenerator(boolean includeAbstract) {
        this.includeAbstract = includeAbstract;
    }

    @Override
    public void generate(Model model, MolgenisOptions options) throws Exception {
        if (!options.generate_tests) {
            this.generate(model, options, false);
        }
    }

    protected void generate(Model model, MolgenisOptions options, boolean generateTests) throws Exception {
        String templatePostFix;
        Template template;
        if (generateTests) {
            template = this.createTemplate(this.getClass().getSimpleName().replace("Gen", "TestGen") + this.getExtension() + ".ftl");
            templatePostFix = "Test";
        } else {
            template = this.createTemplate(this.getClass().getSimpleName() + this.getExtension() + ".ftl");
            templatePostFix = "";
        }
        Map<String, Object> templateArgs = this.createTemplateArguments(options);
        for (Entity entity : model.getEntities()) {
            String packageName = entity.getNamespace().toLowerCase() + this.getClass().getPackage().toString().substring(Generator.class.getPackage().toString().length());
            File targetDir = new File(this.getSourcePath(options) + packageName.replace(".", "/"));
            if (this.handwritten) {
                targetDir = new File(this.getHandWrittenPath(options) + packageName.replace(".", "/"));
            }
            if (entity.isImported() || entity.isAbstract() && !this.includeAbstract || this.skipSystem().booleanValue() && entity.isSystem()) continue;
            File targetFile = new File(targetDir + "/" + GeneratorHelper.getJavaName(entity.getName()) + this.getType() + templatePostFix + this.getExtension());
            if (this.handwritten && targetFile.exists()) continue;
            boolean created = targetDir.mkdirs();
            if (!created && !targetDir.exists()) {
                throw new IOException("could not create " + targetDir);
            }
            templateArgs.put("entity", entity);
            templateArgs.put("model", model);
            templateArgs.put("template", template.getName());
            templateArgs.put("file", targetDir + "/" + GeneratorHelper.getJavaName(entity.getName()) + this.getType() + templatePostFix + this.getExtension());
            templateArgs.put("package", packageName);
            templateArgs.put("jpa_use_sequence", options.jpa_use_sequence);
            FileOutputStream targetOut = new FileOutputStream(targetFile);
            template.process(templateArgs, (Writer)new OutputStreamWriter((OutputStream)targetOut, Charset.forName("UTF-8")));
            ((OutputStream)targetOut).close();
            LOG.info("generated " + targetFile);
        }
    }

    public String getType() {
        String className = this.getClass().getSimpleName();
        return className.substring(0, className.length() - 3);
    }

    public Boolean skipSystem() {
        return Boolean.FALSE;
    }

    public boolean isHandwritten() {
        return this.handwritten;
    }

    public void setHandwritten(boolean handwritten) {
        this.handwritten = handwritten;
    }

    public boolean isIncludeAbstract() {
        return this.includeAbstract;
    }

    public void setIncludeAbstract(boolean includeAbstract) {
        this.includeAbstract = includeAbstract;
    }
}

