/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class GsonFactoryBean
implements FactoryBean<Gson>,
InitializingBean {
    private boolean serializeNulls = false;
    private boolean prettyPrinting = false;
    private boolean disableHtmlEscaping = false;
    private String dateFormatPattern = "yyyy-MM-dd'T'HH:mm:ssZ";
    private List<TypeAdapterFactory> typeAdapterFactoryList;
    private Gson gson;

    public void setSerializeNulls(boolean serializeNulls) {
        this.serializeNulls = serializeNulls;
    }

    public void setPrettyPrinting(boolean prettyPrinting) {
        this.prettyPrinting = prettyPrinting;
    }

    public void setDisableHtmlEscaping(boolean disableHtmlEscaping) {
        this.disableHtmlEscaping = disableHtmlEscaping;
    }

    public void setDateFormatPattern(String dateFormatPattern) {
        this.dateFormatPattern = dateFormatPattern;
    }

    public void registerTypeAdapterFactory(TypeAdapterFactory typeAdapterFactory) {
        if (this.typeAdapterFactoryList == null) {
            this.typeAdapterFactoryList = new ArrayList<TypeAdapterFactory>();
        }
        this.typeAdapterFactoryList.add(typeAdapterFactory);
    }

    public void afterPropertiesSet() {
        GsonBuilder builder = new GsonBuilder();
        if (this.serializeNulls) {
            builder.serializeNulls();
        }
        if (this.prettyPrinting) {
            builder.setPrettyPrinting();
        }
        if (this.disableHtmlEscaping) {
            builder.disableHtmlEscaping();
        }
        if (this.dateFormatPattern != null) {
            builder.setDateFormat(this.dateFormatPattern);
        }
        if (this.typeAdapterFactoryList != null) {
            this.typeAdapterFactoryList.forEach(arg_0 -> ((GsonBuilder)builder).registerTypeAdapterFactory(arg_0));
        }
        this.gson = builder.create();
    }

    public Gson getObject() {
        return this.gson;
    }

    public Class<?> getObjectType() {
        return Gson.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

