/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.db;

import org.molgenis.framework.db.WebAppDatabasePopulatorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;

public class WebAppDatabasePopulator
implements ApplicationListener<ContextRefreshedEvent>,
Ordered {
    private static final Logger LOG = LoggerFactory.getLogger(WebAppDatabasePopulator.class);
    private final WebAppDatabasePopulatorService webAppDatabasePopulatorService;

    public WebAppDatabasePopulator(WebAppDatabasePopulatorService webAppDatabasePopulatorService) {
        if (webAppDatabasePopulatorService == null) {
            throw new IllegalArgumentException("Web app database populator service is null");
        }
        this.webAppDatabasePopulatorService = webAppDatabasePopulatorService;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (!this.webAppDatabasePopulatorService.isDatabasePopulated()) {
            LOG.info("initializing application database");
            this.webAppDatabasePopulatorService.populateDatabase();
            LOG.info("initialized application database");
        }
    }

    public int getOrder() {
        return -2147483548;
    }
}

