/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.model.elements;

import org.molgenis.model.MolgenisModelException;
import org.molgenis.model.elements.UISchema;

public class Menu
extends UISchema {
    static final long serialVersionUID = -1842653490799425686L;
    private Position position = null;

    public Menu(String name, UISchema parent) {
        super(name, parent);
    }

    public Position getPosition() {
        if (this.position == null) {
            if (this.getParent() instanceof Menu) {
                return ((Menu)this.getParent()).getPosition();
            }
            return Position.TOP_LEFT;
        }
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    @Override
    public String toString() {
        return String.format("Menu(name=%s, group=%s, groupRead=%s)", this.getName(), this.getGroup(), this.getGroupRead());
    }

    @Override
    public UISchema.Type getType() {
        return UISchema.Type.MENU;
    }

    public static enum Position {
        TOP_LEFT("top_left"),
        TOP_RIGHT("top_right"),
        LEFT("left");

        private String tag;

        private Position(String tag) {
            this.tag = tag;
        }

        public String toString() {
            return this.tag;
        }

        public static Position getPosition(String position) throws MolgenisModelException {
            StringBuilder optionsBuilder = new StringBuilder();
            for (Position p : Position.values()) {
                if (p.toString().equalsIgnoreCase(position)) {
                    return p;
                }
                optionsBuilder.append(p.toString()).append(", ");
            }
            throw new MolgenisModelException("position='" + position + "' is UNKNOWN for menu. Valid options: " + optionsBuilder.toString());
        }
    }
}

