/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.model.elements;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.molgenis.model.MolgenisModelException;
import org.molgenis.model.elements.DBSchema;
import org.molgenis.model.elements.Entity;
import org.molgenis.model.elements.Field;
import org.molgenis.model.elements.Matrix;
import org.molgenis.model.elements.Method;
import org.molgenis.model.elements.MethodSchema;
import org.molgenis.model.elements.Module;
import org.molgenis.model.elements.Record;
import org.molgenis.model.elements.UISchema;
import org.molgenis.model.elements.View;

public class Model
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String label;
    private DBSchema database;
    private UISchema userinterface;
    private MethodSchema methods;
    private String database_description;
    private String userinterface_description;
    private String processing_description;

    public Model(String name) {
        this.name = name;
        this.database = new DBSchema(name, null, this);
        this.userinterface = new UISchema(name, null);
        this.methods = new MethodSchema(name, null);
        this.database_description = "";
        this.userinterface_description = "";
        this.processing_description = "";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLabel() {
        if (this.label == null) {
            return this.getName();
        }
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public DBSchema getDatabase() {
        return this.database;
    }

    public UISchema getUserinterface() {
        return this.userinterface;
    }

    public MethodSchema getMethodSchema() {
        return this.methods;
    }

    public String getDBDescription() {
        return this.database_description;
    }

    public void setDBDescription(String description) {
        this.database_description = description;
    }

    public String getUIDescription() {
        return this.userinterface_description;
    }

    public void setUIDescription(String description) {
        this.userinterface_description = description;
    }

    public String getPRDescription() {
        return this.processing_description;
    }

    public void setPRDescription(String description) {
        this.processing_description = description;
    }

    public Vector<View> getViews() {
        Vector<View> views = new Vector<View>();
        for (DBSchema element : this.database.getChildren()) {
            if (!element.getClass().equals(View.class)) continue;
            views.add((View)element);
        }
        return views;
    }

    public Vector<Entity> getEntities() {
        return this.getEntities(true);
    }

    public Vector<Entity> getRootEntities() {
        Vector<Entity> entities = new Vector<Entity>();
        ArrayList<String> entitiesInModules = new ArrayList<String>();
        for (Module m : this.getDatabase().getModules()) {
            for (Entity e : m.getEntities()) {
                entitiesInModules.add(e.getName());
            }
        }
        for (DBSchema element : this.database.getChildren()) {
            if (!element.getClass().equals(Entity.class) || entitiesInModules.contains(((Entity)element).getName()) || ((Entity)element).isAssociation()) continue;
            entities.add((Entity)element);
        }
        return entities;
    }

    public Vector<Entity> getEntities(boolean includeSystemTable, boolean includeNonConcretes) {
        Vector<Entity> entities = new Vector<Entity>();
        for (DBSchema element : this.database.getChildren()) {
            if (!element.getClass().equals(Entity.class) || !includeSystemTable && ((Entity)element).isSystem() || !includeNonConcretes && ((Entity)element).isAbstract()) continue;
            entities.add((Entity)element);
        }
        return entities;
    }

    public Vector<Entity> getEntities(boolean includeSystemTable) {
        return this.getEntities(includeSystemTable, true);
    }

    public List<Module> getModules() {
        return this.getDatabase().getModules();
    }

    public Vector<Matrix> getMatrices() {
        Vector<Matrix> matrices = new Vector<Matrix>();
        for (DBSchema element : this.database.getChildren()) {
            if (!element.getClass().equals(Matrix.class)) continue;
            matrices.add((Matrix)element);
        }
        return matrices;
    }

    public Vector<Entity> getConcreteEntities() {
        Vector<Entity> concrete_entities = new Vector<Entity>();
        for (Entity e : this.getEntities()) {
            if (e.isAbstract()) continue;
            concrete_entities.add(e);
        }
        return concrete_entities;
    }

    public Vector<Method> getMethods() {
        Vector<Method> themethods = new Vector<Method>();
        for (MethodSchema element : this.methods.getChildren()) {
            if (!element.getClass().equals(Method.class)) continue;
            themethods.add((Method)element);
        }
        return themethods;
    }

    public Entity getEntity(String name) {
        for (DBSchema element : this.database.getAllChildren()) {
            if (!element.getClass().equals(Entity.class) || !element.getName().equalsIgnoreCase(name)) continue;
            return (Entity)element;
        }
        return null;
    }

    public Record getRecord(String name) {
        for (DBSchema element : this.database.getChildren()) {
            if (!element.getName().equals(name)) continue;
            for (Class<?> cl : element.getClass().getInterfaces()) {
                if (!cl.equals(Record.class)) continue;
                return (Record)((Object)element);
            }
        }
        return null;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (Entity e : this.getEntities()) {
            result.append("ENTITY: " + e.toString() + "\n");
        }
        for (Matrix m : this.getMatrices()) {
            result.append("MATRIX: " + m.toString() + "\n");
        }
        for (UISchema u : this.getUserinterface().getAllChildren()) {
            result.append(u.toString() + "\n");
        }
        return result.toString();
    }

    public Field findField(String f) throws MolgenisModelException {
        StringTokenizer tok = new StringTokenizer(f, ".");
        String entity = null;
        String field = null;
        if (tok.countTokens() == 1) {
            field = tok.nextToken();
        } else if (tok.countTokens() == 2) {
            entity = tok.nextToken();
            field = tok.nextToken();
        } else {
            throw new MolgenisModelException("field with name '" + f + " is unknown" + tok.countTokens());
        }
        Field result = null;
        if (entity != null) {
            Entity em;
            try {
                em = this.getEntity(entity);
            }
            catch (Exception e) {
                throw new MolgenisModelException("field with name '" + f + " is unknown: " + e.getMessage());
            }
            result = em.getAllField(field);
        } else {
            int count = 0;
            for (Entity em : this.getEntities()) {
                for (Field fm : em.getAllFields()) {
                    if (!fm.getName().equalsIgnoreCase(field)) continue;
                    result = fm;
                    if (++count <= 1) continue;
                    throw new MolgenisModelException("field with name '" + f + " is not unique, please provide entity also in format {entity}.{field}");
                }
            }
        }
        if (result != null) {
            return result;
        }
        throw new MolgenisModelException("field with name '" + f + "' is unknown: ");
    }

    public int getNumberOfReferencesTo(Entity e) throws MolgenisModelException {
        int count = 0;
        for (Entity entity : this.getEntities()) {
            for (Field field : entity.getImplementedFields()) {
                String xrefEntity;
                if (!field.isXRef() && !field.isMRef() || (xrefEntity = field.getXrefEntityName()) == null || !xrefEntity.equals(e.getName())) continue;
                ++count;
            }
        }
        return count;
    }
}

