/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.generators.db;

import freemarker.template.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.molgenis.MolgenisOptions;
import org.molgenis.generators.Generator;
import org.molgenis.model.MolgenisModel;
import org.molgenis.model.elements.Entity;
import org.molgenis.model.elements.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntitiesImporterGen
extends Generator {
    private static final Logger LOG = LoggerFactory.getLogger(EntitiesImporterGen.class);

    @Override
    public String getDescription() {
        return "Generates EntitiesImporter";
    }

    @Override
    public void generate(Model model, MolgenisOptions options) throws Exception {
        if (!options.generate_tests) {
            Template template = this.createTemplate("/" + this.getClass().getSimpleName() + ".java.ftl");
            Map<String, Object> templateArgs = this.createTemplateArguments(options);
            List<Entity> entityList = model.getEntities();
            entityList = MolgenisModel.sortEntitiesByDependency(entityList, model);
            File target = new File(this.getSourcePath(options) + "org/molgenis" + "/EntitiesImporterImpl.java");
            boolean created = target.getParentFile().mkdirs();
            if (!created && !target.getParentFile().exists()) {
                throw new IOException("could not create " + target.getParentFile());
            }
            templateArgs.put("model", model);
            templateArgs.put("entities", entityList);
            templateArgs.put("package", "org/molgenis".replace('/', '.'));
            FileOutputStream targetOut = new FileOutputStream(target);
            template.process(templateArgs, (Writer)new OutputStreamWriter((OutputStream)targetOut, Charset.forName("UTF-8")));
            ((OutputStream)targetOut).close();
            LOG.info("generated " + target);
        }
    }
}

