/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ListEscapeUtils {
    private static final int INITIAL_STRING_SIZE = 128;
    public static final char DEFAULT_SEPARATOR = ',';
    public static final char DEFAULT_ESCAPE_CHAR = '\\';

    private ListEscapeUtils() {
    }

    public static String toString(List<?> list) {
        return ListEscapeUtils.toString(list, ',', '\\');
    }

    public static String toString(List<?> list, char sep) {
        return ListEscapeUtils.toString(list, sep, '\\');
    }

    public static String toString(List<?> list, char sep, char esc) {
        if (sep == esc) {
            throw new IllegalArgumentException("separator and escape char are equal");
        }
        if (list == null) {
            return null;
        }
        StringBuilder strBuilder = new StringBuilder(128);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            String str;
            Object obj;
            if (i > 0) {
                strBuilder.append(sep);
            }
            if ((obj = list.get(i)) == null || (str = obj.toString()) == null) continue;
            int nrChars = str.length();
            for (int j = 0; j < nrChars; ++j) {
                char c = str.charAt(j);
                if (c == sep || c == esc) {
                    strBuilder.append(esc);
                }
                strBuilder.append(c);
            }
        }
        return strBuilder.toString();
    }

    public static List<String> toList(String str) {
        return ListEscapeUtils.toList(str, ',', '\\');
    }

    public static List<String> toList(String str, char sep) {
        return ListEscapeUtils.toList(str, sep, '\\');
    }

    public static List<String> toList(String str, char sep, char esc) {
        if (sep == esc) {
            throw new IllegalArgumentException("separator and escape char are equal");
        }
        if (str == null) {
            return null;
        }
        if (str.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder strBuilder = new StringBuilder(128);
        boolean isEscape = false;
        int nrChars = str.length();
        for (int j = 0; j < nrChars; ++j) {
            char c = str.charAt(j);
            if (!isEscape) {
                if (c == esc) {
                    if (j + 1 < nrChars) {
                        char cnext = str.charAt(j + 1);
                        if (cnext != sep && cnext != esc) {
                            strBuilder.append(c);
                            continue;
                        }
                        isEscape = true;
                        continue;
                    }
                    strBuilder.append(c);
                    continue;
                }
                if (c == sep) {
                    list.add(strBuilder.toString().trim());
                    strBuilder.setLength(0);
                    continue;
                }
                strBuilder.append(c);
                continue;
            }
            strBuilder.append(c);
            isEscape = false;
        }
        list.add(strBuilder.toString().trim());
        return list;
    }
}

