/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    public static void compress(List<File> files, File outputZIP, DirectoryStructure ds) throws IOException {
        if (outputZIP.isDirectory()) {
            throw new IllegalArgumentException(String.format("Zip outputfile can't be a directory. %s ", outputZIP));
        }
        int BUFFER = 2048;
        BufferedInputStream origin = null;
        FileOutputStream dest = new FileOutputStream(outputZIP.getAbsolutePath());
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));
        byte[] data = new byte[2048];
        for (File f : files) {
            int count;
            FileInputStream fi = new FileInputStream(f);
            origin = new BufferedInputStream(fi, 2048);
            ZipEntry entry = new ZipEntry(ds.getPath(f));
            out.putNextEntry(entry);
            while ((count = origin.read(data, 0, 2048)) != -1) {
                out.write(data, 0, count);
            }
            origin.close();
        }
        out.close();
    }

    public static enum DirectoryStructure {
        INCLUDE_DIR{

            @Override
            String getPath(File f) {
                return f.getAbsolutePath();
            }
        }
        ,
        EXCLUDE_DIR{

            @Override
            String getPath(File f) {
                return f.getName();
            }
        };


        abstract String getPath(File var1);
    }
}

