/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.util;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.InteractiveCallback;
import ch.ethz.ssh2.LocalPortForwarder;
import ch.ethz.ssh2.SCPClient;
import ch.ethz.ssh2.Session;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.molgenis.util.SshResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ssh {
    private static final Logger LOG = LoggerFactory.getLogger(Ssh.class);
    private String hostname;
    private String username;
    private String password;
    private int timeout = 10000;
    private int port = 22;
    Connection conn;
    Session sess;
    LocalPortForwarder lpf;

    public Ssh(String host, String user, String password) throws IOException {
        this(host, user, password, 22);
    }

    public Ssh(String host, String user, String password, int port) throws IOException {
        this.hostname = host;
        this.username = user;
        this.password = password;
        this.port = port;
        this.connect();
    }

    public Ssh(String host, String user, String password, int port, String forwardHost, String forwardUser, String forwardPassword, int forwardPort) throws IOException {
        Ssh forwardSsh = new Ssh(forwardHost, forwardUser, forwardPassword, forwardPort);
        forwardSsh.forward(9999, host, port);
        this.hostname = "127.0.0.1";
        this.username = user;
        this.password = password;
        this.port = 9999;
        this.connect();
    }

    public void forward(int local_port, String host_to_connect, int port_to_connect) throws IOException {
        LOG.debug("creating a tunnel from L:" + local_port + "->" + host_to_connect + ":" + port_to_connect);
        this.lpf = this.conn.createLocalPortForwarder(local_port, host_to_connect, port_to_connect);
    }

    private void connect() throws IOException {
        LOG.debug("trying to connect to " + this.username + "@" + this.hostname + ":" + this.port);
        this.conn = new Connection(this.hostname, this.port);
        this.conn.connect();
        try {
            boolean isAuthenticated = this.conn.authenticateWithPassword(this.username, this.password);
            if (!isAuthenticated) {
                throw new IOException("Authentication failed.");
            }
        }
        catch (Exception e) {
            this.conn.authenticateWithKeyboardInteractive(this.username, new InteractiveCallback(){

                public String[] replyToChallenge(String name, String instruction, int numPrompts, String[] prompt, boolean[] echo) throws Exception {
                    String[] responses = new String[numPrompts];
                    for (int x = 0; x < numPrompts; ++x) {
                        responses[x] = Ssh.this.password;
                    }
                    return responses;
                }
            });
        }
        LOG.debug("connected to " + this.username + "@" + this.hostname + ":" + this.port);
    }

    public SshResult executeCommand(String command) throws IOException {
        return this.executeCommand(command, this.timeout);
    }

    public SshResult executeCommand(String command, int timeout) throws IOException {
        LOG.debug("executing command: " + command);
        try {
            this.sess = this.conn.openSession();
            StringBuffer stdOutBuffer = new StringBuffer();
            StringBuffer stdErrBuffer = new StringBuffer();
            InputStream stdout = this.sess.getStdout();
            InputStream stderr = this.sess.getStderr();
            this.sess.execCommand(command);
            byte[] buffer = new byte[8192];
            block5: while (true) {
                int len;
                if (stdout.available() == 0 && stderr.available() == 0) {
                    int conditions = this.sess.waitForCondition(28, (long)timeout);
                    if ((conditions & 1) != 0) {
                        throw new IOException("Timeout while waiting for data from peer.");
                    }
                    if ((conditions & 0x10) != 0 && (conditions & 0xC) == 0) break;
                    if ((conditions & 0xC) == 0) {
                        throw new IOException("Unexpected condition result (" + conditions + ")");
                    }
                }
                while (stdout.available() > 0) {
                    len = stdout.read(buffer);
                    if (len <= 0) continue;
                    stdOutBuffer.append(new String(buffer, 0, len, Charset.forName("UTF-8")));
                }
                while (true) {
                    if (stderr.available() <= 0) continue block5;
                    len = stderr.read(buffer);
                    if (len <= 0) continue;
                    stdErrBuffer.append(new String(buffer, 0, len, Charset.forName("UTF-8")));
                }
                break;
            }
            SshResult sshResult = new SshResult(stdOutBuffer.toString(), stdErrBuffer.toString());
            return sshResult;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            this.sess.close();
        }
    }

    public void close() {
        if (this.lpf != null) {
            try {
                this.lpf.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.sess.close();
        this.conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadFile(File localFile, String remoteFile) throws IOException {
        LOG.debug("upload local file '" + localFile + "' to remote file '" + remoteFile + "'");
        SCPClient scp = this.conn.createSCPClient();
        try (FileOutputStream out = new FileOutputStream(localFile);){
            if (remoteFile.contains("/")) {
                String dir = remoteFile.substring(0, remoteFile.lastIndexOf("/"));
                String file = remoteFile.substring(remoteFile.lastIndexOf("/") + 1);
                scp.put(localFile.getAbsolutePath(), file, dir, "0600");
            } else {
                scp.put(localFile.getAbsolutePath(), remoteFile, "", "0600");
            }
            out.flush();
        }
        LOG.debug("upload file complete");
    }

    public void uploadStringToFile(String string, String remoteFile) throws IOException {
        LOG.debug("upload string to remote file '" + remoteFile + "'");
        SCPClient scp = this.conn.createSCPClient();
        if (remoteFile.contains("/")) {
            String dir = remoteFile.substring(0, remoteFile.lastIndexOf("/"));
            String file = remoteFile.substring(remoteFile.lastIndexOf("/") + 1);
            scp.put(string.getBytes("UTF-8"), file, dir, "0600");
        } else {
            scp.put(string.getBytes("UTF-8"), remoteFile, "", "0600");
        }
        LOG.debug("upload file complete");
    }

    public void uploadStringToFile(String string, String remoteFile, String remoteDir) throws IOException {
        if (!"".equals(remoteDir)) {
            this.uploadStringToFile(string, remoteDir + "/" + remoteFile);
        } else {
            this.uploadStringToFile(string, remoteFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadFile(String remoteFile, File localFile) throws IOException {
        LOG.debug("download remote file '" + remoteFile + "' to local file " + localFile);
        SCPClient scp = this.conn.createSCPClient();
        try (FileOutputStream out = new FileOutputStream(localFile);){
            scp.get(remoteFile, (OutputStream)out);
            out.flush();
        }
        LOG.debug("download file complete");
    }

    public String downloadFileIntoString(String remoteFile) throws IOException {
        LOG.debug("download remote file '" + remoteFile);
        SCPClient scp = this.conn.createSCPClient();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        scp.get(remoteFile, (OutputStream)out);
        return out.toString("UTF-8");
    }

    protected void finalize() {
        this.close();
    }

    public String getHost() {
        return this.hostname;
    }

    public void setHost(String host) {
        this.hostname = host;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String downloadFile(String remoteFile) throws IOException {
        LOG.debug("download remoteFile file '" + remoteFile + "' as string");
        SCPClient scp = this.conn.createSCPClient();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        scp.get(remoteFile, (OutputStream)out);
        LOG.debug("download file complete");
        return out.toString("UTF-8");
    }
}

