/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.molgenis.MolgenisFieldTypes;
import org.molgenis.MolgenisOptions;
import org.molgenis.Version;
import org.molgenis.fieldtypes.BoolField;
import org.molgenis.fieldtypes.DateField;
import org.molgenis.fieldtypes.DatetimeField;
import org.molgenis.fieldtypes.DecimalField;
import org.molgenis.fieldtypes.EnumField;
import org.molgenis.fieldtypes.FileField;
import org.molgenis.fieldtypes.HyperlinkField;
import org.molgenis.fieldtypes.ImageField;
import org.molgenis.fieldtypes.IntField;
import org.molgenis.fieldtypes.LongField;
import org.molgenis.fieldtypes.MrefField;
import org.molgenis.fieldtypes.StringField;
import org.molgenis.fieldtypes.TextField;
import org.molgenis.fieldtypes.XrefField;
import org.molgenis.generators.DataTypeGen;
import org.molgenis.generators.EntityMetaDataGen;
import org.molgenis.generators.Generator;
import org.molgenis.generators.JpaRepositoryGen;
import org.molgenis.generators.JpaRepositorySourceGen;
import org.molgenis.generators.db.DatabaseConfigGen;
import org.molgenis.generators.db.EntitiesImporterGen;
import org.molgenis.generators.db.EntitiesValidatorGen;
import org.molgenis.generators.db.JDBCMetaDatabaseGen;
import org.molgenis.generators.db.PersistenceGen;
import org.molgenis.generators.doc.DotDocGen;
import org.molgenis.generators.doc.DotDocMinimalGen;
import org.molgenis.generators.doc.DotDocModuleDependencyGen;
import org.molgenis.generators.doc.FileFormatDocGen;
import org.molgenis.generators.doc.ObjectModelDocGen;
import org.molgenis.model.MolgenisModel;
import org.molgenis.model.elements.Model;

public class Molgenis {
    private static final Logger logger = Logger.getLogger(Molgenis.class);
    MolgenisOptions options = null;
    Model model = null;
    List<Generator> generators = new ArrayList<Generator>();

    public static void main(String[] args) {
        block5: {
            try {
                if (args.length == 2) {
                    new Molgenis(args[0], args[1]).generate();
                    break block5;
                }
                if (args.length == 3) {
                    if (args[2].equals("--generatetests")) {
                        new Molgenis(args[0], args[1]).generateTests();
                        break block5;
                    }
                    throw new Exception("Bad second argument: use either --updatedb or --updatedbfillmeta");
                }
                throw new Exception("You have to provide the molgenis.properties file as first argument to generate Molgenis.\nAlternatively, add the additional argument --updatedb OR --updatedbfillmeta to perform the update database action.\nThe --updatedbfillmeta will also insert the metadata into the database.\nYour arguments:\n" + Arrays.toString(args));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public List<Generator> getGenerators() {
        return this.generators;
    }

    public void setGenerators(List<Generator> generators) {
        this.generators = generators;
    }

    public Molgenis(String propertiesFile, Class<? extends Generator> ... generatorsToUse) throws Exception {
        this(new MolgenisOptions(propertiesFile), (String)null, generatorsToUse);
    }

    public Molgenis(String propertiesFile, String outputPath, Class<? extends Generator> ... generatorsToUse) throws Exception {
        this(new MolgenisOptions(propertiesFile), outputPath, generatorsToUse);
    }

    public Molgenis(String propertiesFile) throws Exception {
        this(new MolgenisOptions(propertiesFile), (String)null, (Class<? extends Generator>[])new Class[0]);
    }

    public Molgenis(String propertiesFile, String outputPath) throws Exception {
        this(new MolgenisOptions(propertiesFile), outputPath, new Class[0]);
    }

    public Molgenis() {
    }

    public void init(String propertiesFile, String outputPath, Class<? extends Generator> ... generatorsToUse) throws Exception {
        new Molgenis(new MolgenisOptions(propertiesFile), outputPath, generatorsToUse);
    }

    public <E extends Generator> Molgenis(MolgenisOptions options, Class<? extends Generator> ... generatorsToUse) throws Exception {
        this(options, (String)null, generatorsToUse);
    }

    public <E extends Generator> Molgenis(MolgenisOptions options, String outputPath, Class<? extends Generator> ... generatorsToUse) throws Exception {
        BasicConfigurator.configure();
        this.loadFieldTypes();
        this.options = options;
        Logger.getLogger((String)"freemarker.cache").setLevel(Level.INFO);
        logger.debug((Object)("\nMOLGENIS version " + Version.convertToString()));
        logger.debug((Object)("working dir: " + System.getProperty("user.dir")));
        if (outputPath != null && !(outputPath = outputPath.replace('\\', '/')).endsWith("/")) {
            outputPath = outputPath + "/";
        }
        String string = options.output_src = outputPath != null ? outputPath + options.output_src : options.output_src;
        if (!options.output_src.endsWith("/")) {
            options.output_src = options.output_src.endsWith("/") + "/";
        }
        String string2 = options.output_hand = outputPath != null ? outputPath + options.output_hand : options.output_hand;
        if (!options.output_hand.endsWith("/")) {
            options.output_hand = options.output_hand + "/";
        }
        String string3 = options.output_web = outputPath != null ? outputPath + options.output_web : options.output_web;
        if (!options.output_web.endsWith("/")) {
            options.output_web = options.output_web + "/";
        }
        String string4 = options.output_doc = outputPath != null ? outputPath + options.output_doc : options.output_doc;
        if (!options.output_doc.endsWith("/")) {
            options.output_doc = options.output_doc + "/";
        }
        if (options.generate_doc) {
            this.generators.add(new FileFormatDocGen());
            try {
                Runtime.getRuntime().exec("dot -?");
                this.generators.add(new DotDocGen());
                this.generators.add(new DotDocMinimalGen());
            }
            catch (Exception e) {
                // empty catch block
            }
            this.generators.add(new ObjectModelDocGen());
            this.generators.add(new DotDocModuleDependencyGen());
        } else {
            logger.debug((Object)"Skipping documentation ....");
        }
        if (options.generate_jpa) {
            if (options.generate_db) {
                this.generators.add(new DatabaseConfigGen());
            }
            this.generators.add(new DataTypeGen());
            this.generators.add(new EntityMetaDataGen());
            this.generators.add(new JpaRepositoryGen());
            this.generators.add(new JDBCMetaDatabaseGen());
            if (options.generate_persistence) {
                this.generators.add(new PersistenceGen());
            }
            if (options.generate_jpa_repository_source) {
                this.generators.add(new JpaRepositorySourceGen());
            }
        } else {
            logger.warn((Object)"SEVERE: Skipping ALL SQL ....");
        }
        if (options.generate_entityio) {
            this.generators.add(new EntitiesImporterGen());
            this.generators.add(new EntitiesValidatorGen());
        }
        ArrayList<Generator> use = new ArrayList<Generator>();
        if (!ArrayUtils.isEmpty((Object[])generatorsToUse)) {
            for (Class<? extends Generator> c : generatorsToUse) {
                use.add(c.newInstance());
            }
            this.generators = use;
        }
        logger.debug((Object)("\nUsing generators:\n" + this.toString()));
        this.model = MolgenisModel.parse(options);
    }

    private void loadFieldTypes() {
        MolgenisFieldTypes.addType(new BoolField());
        MolgenisFieldTypes.addType(new DateField());
        MolgenisFieldTypes.addType(new DatetimeField());
        MolgenisFieldTypes.addType(new DecimalField());
        MolgenisFieldTypes.addType(new EnumField());
        MolgenisFieldTypes.addType(new FileField());
        MolgenisFieldTypes.addType(new ImageField());
        MolgenisFieldTypes.addType(new HyperlinkField());
        MolgenisFieldTypes.addType(new LongField());
        MolgenisFieldTypes.addType(new MrefField());
        MolgenisFieldTypes.addType(new StringField());
        MolgenisFieldTypes.addType(new TextField());
        MolgenisFieldTypes.addType(new XrefField());
        MolgenisFieldTypes.addType(new IntField());
    }

    public void generateTests() throws Exception {
        this.options.setGenerateTests(true);
        this.generate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() throws Exception {
        logger.info((Object)"Generating ...");
        logger.debug((Object)("\nUsing options:\n" + this.options.toString()));
        File generatedFolder = new File(this.options.output_dir);
        if (generatedFolder.exists() && this.options.delete_generated_folder) {
            logger.debug((Object)("removing previous generated folder " + generatedFolder));
            Molgenis.deleteContentOfDirectory(generatedFolder);
            Molgenis.deleteContentOfDirectory(new File(this.options.output_src));
            Molgenis.deleteContentOfDirectory(new File(this.options.output_sql));
        }
        int nrCores = Runtime.getRuntime().availableProcessors();
        ExecutorService executorService = Executors.newFixedThreadPool(nrCores);
        try {
            executorService.invokeAll(Lists.transform(this.generators, (Function)new Function<Generator, Callable<Boolean>>(){

                @Nullable
                public Callable<Boolean> apply(final @Nullable Generator generator) {
                    return generator != null ? new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            generator.generate(Molgenis.this.model, Molgenis.this.options);
                            return true;
                        }
                    } : null;
                }
            }));
        }
        finally {
            executorService.shutdown();
        }
        logger.info((Object)("Generation completed at " + new Date()));
    }

    public static boolean deleteContentOfDirectory(File path) {
        boolean result = true;
        if (path.exists()) {
            File[] files;
            for (File f : files = path.listFiles()) {
                if (f.isHidden()) continue;
                if (f.isDirectory()) {
                    result &= Molgenis.deleteContentOfDirectory(f);
                    boolean ok = f.delete();
                    if (ok) continue;
                    logger.warn((Object)("file delete failed: " + f.getName()));
                    continue;
                }
                result &= f.delete();
            }
        }
        return result;
    }

    public final String toString() {
        StringBuffer result = new StringBuffer();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        int padding = 0;
        for (Generator generator : this.generators) {
            String generatorName = null;
            generatorName = generator.getClass().getName().indexOf(this.getClass().getPackage().getName()) == 0 ? generator.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1) : generator.getClass().getName();
            padding = Math.max(padding, generatorName.length());
            map.put(generatorName, generator.getDescription());
        }
        for (Map.Entry entry : map.entrySet()) {
            String spaces = "";
            for (int i = ((String)entry.getKey()).toString().length(); i < padding; ++i) {
                spaces = spaces + " ";
            }
            result.append((String)entry.getKey() + spaces + " #" + (String)entry.getValue() + "\n");
        }
        return result.toString();
    }

    public MolgenisOptions getMolgenisOptions() {
        return this.options;
    }
}

