/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.fieldtypes;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import org.molgenis.MolgenisFieldTypes;
import org.molgenis.model.MolgenisModelException;
import org.molgenis.model.elements.Entity;
import org.molgenis.model.elements.Field;

public abstract class FieldType
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Field f;

    public FieldType getFieldType(Field f) throws MolgenisModelException {
        return MolgenisFieldTypes.get(f);
    }

    public Entity getEntityByName(String name) {
        return (Entity)this.f.getEntity().get(name);
    }

    public String getJavaSetterType() throws MolgenisModelException {
        return this.getJavaPropertyType();
    }

    public abstract String getJavaPropertyType() throws MolgenisModelException;

    public abstract String getCppPropertyType() throws MolgenisModelException;

    public abstract String getJavaPropertyDefault() throws MolgenisModelException;

    public abstract String getJavaAssignment(String var1) throws MolgenisModelException;

    public abstract Class<?> getJavaType() throws MolgenisModelException;

    public abstract String getMysqlType() throws MolgenisModelException;

    public abstract String getXsdType() throws MolgenisModelException;

    public String toCsv(List<String> elements) {
        StringBuilder strBuilder = new StringBuilder();
        for (String str : elements) {
            strBuilder.append('\'').append(str).append('\'').append(',');
        }
        if (!elements.isEmpty()) {
            strBuilder.deleteCharAt(strBuilder.length() - 1);
        }
        return strBuilder.toString();
    }

    public abstract String getHsqlType() throws MolgenisModelException;

    public void setField(Field f) {
        this.f = f;
    }

    public abstract String getFormatString();

    public String toString() {
        return this.getClass().getSimpleName().replace("Field", "").toLowerCase();
    }

    public abstract String getCppJavaPropertyType() throws MolgenisModelException;

    public abstract String getOracleType() throws MolgenisModelException;

    public abstract Object getTypedValue(String var1) throws ParseException;

    public abstract MolgenisFieldTypes.FieldTypeEnum getEnumType();

    public List<String> getAllowedOperators() {
        return Arrays.asList("EQUALS", "NOT EQUALS");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldType fieldType = (FieldType)o;
        return !(this.f != null ? !this.f.equals(fieldType.f) : fieldType.f != null);
    }

    public int hashCode() {
        return this.f != null ? this.f.hashCode() : 0;
    }

    public abstract Object convert(Object var1);
}

