/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.generators;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.molgenis.MolgenisFieldTypes;
import org.molgenis.MolgenisOptions;
import org.molgenis.fieldtypes.EnumField;
import org.molgenis.fieldtypes.FieldType;
import org.molgenis.fieldtypes.FileField;
import org.molgenis.fieldtypes.ImageField;
import org.molgenis.fieldtypes.IntField;
import org.molgenis.fieldtypes.MrefField;
import org.molgenis.fieldtypes.XrefField;
import org.molgenis.model.MolgenisModelException;
import org.molgenis.model.elements.Entity;
import org.molgenis.model.elements.Field;
import org.molgenis.model.elements.Model;
import org.molgenis.model.elements.Unique;

public class GeneratorHelper {
    private static final Logger logger = Logger.getLogger((String)GeneratorHelper.class.getSimpleName());
    MolgenisOptions options;
    MolgenisFieldTypes typeRegistry;

    public GeneratorHelper(MolgenisOptions options) {
        this.options = options;
        this.typeRegistry = new MolgenisFieldTypes();
    }

    public static String firstToUpper(String string) {
        if (string == null) {
            return " NULL ";
        }
        if (string.length() > 0) {
            return string.substring(0, 1).toUpperCase() + string.substring(1);
        }
        return " ERROR[STRING EMPTY] ";
    }

    public static String firstToLower(String string) {
        if (string == null) {
            return " NULL ";
        }
        if (string.length() > 1) {
            return string.substring(0, 1).toLowerCase() + string.substring(1);
        }
        return string;
    }

    public static String toUpper(String string) {
        if (string == null) {
            return " NULL ";
        }
        return string.toUpperCase();
    }

    public static String toLower(String string) {
        if (string == null) {
            return " NULL ";
        }
        return string.toLowerCase();
    }

    public String getType(Field field) throws Exception {
        if (field == null) {
            return "NULLPOINTER";
        }
        try {
            return MolgenisFieldTypes.get(field).getJavaPropertyType();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "EXCEPTION";
        }
    }

    public String getCppType(Field field) throws Exception {
        if (field == null) {
            return "void*";
        }
        try {
            return MolgenisFieldTypes.get(field).getCppPropertyType();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "EXCEPTION";
        }
    }

    public String getCppJavaType(Field field) throws Exception {
        if (field == null) {
            return "Ljava/lang/NULL;";
        }
        try {
            return MolgenisFieldTypes.get(field).getCppJavaPropertyType();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "EXCEPTION";
        }
    }

    public String getSetType(Model model, Field field) throws Exception {
        return MolgenisFieldTypes.get(field).getJavaSetterType();
    }

    public String getDefault(Model model, Field field) throws Exception {
        return MolgenisFieldTypes.get(field).getJavaPropertyDefault();
    }

    public String getJavaAssignment(Field field, String value) throws MolgenisModelException {
        return MolgenisFieldTypes.get(field).getJavaAssignment(value);
    }

    public String toCsv(List<String> elements) {
        StringBuilder strBuilder = new StringBuilder();
        if (elements != null) {
            for (String str : elements) {
                strBuilder.append('\'').append(str).append('\'').append(',');
            }
            if (!elements.isEmpty()) {
                strBuilder.deleteCharAt(strBuilder.length() - 1);
            }
        }
        return strBuilder.toString();
    }

    public String getMysqlType(Model model, Field field) throws Exception {
        return MolgenisFieldTypes.get(field).getMysqlType();
    }

    public String getOracleType(Model model, Field field) throws Exception {
        return MolgenisFieldTypes.get(field).getOracleType();
    }

    public String getXsdType(Model model, Field field) throws Exception {
        return MolgenisFieldTypes.get(field).getXsdType();
    }

    public String getHsqlType(Field field) throws Exception {
        Logger.getLogger((String)"TEST").debug((Object)("trying " + field));
        return MolgenisFieldTypes.get(field).getHsqlType();
    }

    public Vector<Field> getAddFields(Entity e) throws Exception {
        return this.getAddFields(e, false);
    }

    public Vector<Field> getAddFields(Entity e, boolean includeKey) throws Exception {
        Vector<Field> add_fields;
        block3: {
            block2: {
                add_fields = new Vector<Field>();
                if (!this.options.object_relational_mapping.equals("class_per_table")) break block2;
                for (Field f : this.getAllFields(e)) {
                    if (this.isMref(f) || this.isAutoId(f, e) && !includeKey) continue;
                    add_fields.add(f);
                }
                break block3;
            }
            if (!this.options.object_relational_mapping.equals("subclass_per_table")) break block3;
            for (Field f : e.getImplementedFields()) {
                boolean inheritedField;
                boolean bl = inheritedField = f.getEntity().getAncestor() != null && f.getEntity().getAncestor().getAllFields().contains(f);
                if (this.isMref(f) || this.isAutoId(f, e) && !includeKey && !inheritedField) continue;
                add_fields.add(f);
            }
        }
        return add_fields;
    }

    private boolean isMref(Field f) {
        return f.getType() instanceof MrefField;
    }

    private boolean isTypeField(Field f, Entity e) {
        return !e.isRootAncestor() && f.getType() instanceof EnumField && f.getName() == "__Type";
    }

    private boolean isAutoId(Field f, Entity e) {
        return f.getType() instanceof IntField && f.isAuto();
    }

    public Vector<Field> getAllFields(Entity e) throws Exception {
        return this.getAllFields(e, "");
    }

    public Vector<Field> getAllFields(Entity e, String type) throws Exception {
        Vector<Field> all_fields = e.getAllFields();
        for (Field f : e.getAllFields()) {
            if (all_fields.contains(f) || !type.equals("") && !f.getType().toString().equals(type)) continue;
            all_fields.add(f);
        }
        return all_fields;
    }

    public Vector<Field> getDbFields(Entity e, String type) throws Exception {
        Vector<Field> db_fields;
        block3: {
            block2: {
                db_fields = new Vector<Field>();
                if (!this.options.object_relational_mapping.equals("class_per_table")) break block2;
                Vector<Field> all_fields = this.getAllFields(e, type);
                for (Field f : all_fields) {
                    if (f.getType() instanceof MrefField || !type.equals("") && !f.getType().toString().equals(type)) continue;
                    db_fields.add(f);
                }
                break block3;
            }
            if (!this.options.object_relational_mapping.equals("subclass_per_table")) break block3;
            Vector<Field> local_fields = e.getImplementedFields();
            for (Field f : local_fields) {
                if (f.getType() instanceof MrefField || !type.equals("") && !f.getType().toString().equals(type)) continue;
                db_fields.add(f);
            }
        }
        return db_fields;
    }

    public Vector<Field> getViewFields(Entity e, String type) throws Exception {
        Vector<Field> view_fields = new Vector<Field>();
        Vector<Field> all_fields = this.getAllFields(e, type);
        for (Field f : all_fields) {
            if (f.getType() instanceof MrefField || !type.equals("") && !f.getType().toString().equals(type)) continue;
            view_fields.add(f);
        }
        return view_fields;
    }

    public Vector<Field> getUpdateFields(Entity e) throws Exception {
        Vector<Field> all_update_fields = new Vector<Field>();
        List<Field> fields = null;
        fields = e.getImplementedFields().size() > e.getFields().size() ? e.getImplementedFields() : e.getFields();
        for (Field f : fields) {
            if (this.isMref(f) || this.isTypeField(f, e) || f.isReadOnly() && !this.isPrimaryKey(f, e) && !(f.getType() instanceof FileField) && !(f.getType() instanceof ImageField)) continue;
            all_update_fields.add(f);
        }
        return all_update_fields;
    }

    public boolean isPrimaryKey(Field f, Entity e) throws MolgenisModelException {
        return e.getKeyFields(0).contains(f);
    }

    public Vector<Field> getKeyFields(Entity e) throws MolgenisModelException {
        return e.getKeyFields(0);
    }

    public Vector<Unique> getAllKeys(Entity e) throws MolgenisModelException {
        Vector<Unique> all_keys = new Vector<Unique>();
        if (e.getAncestor() != null) {
            all_keys.addAll(this.getAllKeys(e.getAncestor()));
        }
        for (Unique u : e.getKeys()) {
            if (all_keys.contains(u)) continue;
            all_keys.add(u);
        }
        return all_keys;
    }

    public Vector<Unique> getSecondaryKeys(Entity e) throws MolgenisModelException {
        Vector<Unique> allkeys = this.getAllKeys(e);
        Vector<Unique> skeys = new Vector<Unique>();
        if (allkeys.size() > 1) {
            for (int i = 1; i < allkeys.size(); ++i) {
                skeys.add(allkeys.get(i));
            }
        }
        return skeys;
    }

    public Vector<Field> getKeyFields(List<Unique> keys) throws MolgenisModelException {
        LinkedHashMap<String, Field> result = new LinkedHashMap<String, Field>();
        for (Unique u : keys) {
            for (Field f : u.getFields()) {
                if (result.get(f.getName()) != null) continue;
                result.put(f.getName(), f);
            }
        }
        return new Vector<Field>(result.values());
    }

    public Vector<Field> getSecondaryKeyFields(Entity e) throws MolgenisModelException {
        Vector<Unique> keys = this.getSecondaryKeys(e);
        LinkedHashMap<String, Field> result = new LinkedHashMap<String, Field>();
        Iterator i$ = keys.iterator();
        if (i$.hasNext()) {
            Unique u = (Unique)i$.next();
            for (Field f : u.getFields()) {
                if (result.get(f.getName()) != null) continue;
                result.put(f.getName(), f);
            }
        }
        return new Vector<Field>(result.values());
    }

    public Vector<Field> getKeyFields(Unique u) throws MolgenisModelException {
        return u.getFields();
    }

    public Vector<Unique> getTableKeys(Entity e) throws MolgenisModelException {
        Vector<Unique> all_keys = this.getAllKeys(e);
        Vector<Unique> table_keys = new Vector<Unique>();
        if (this.options.object_relational_mapping.equals("subclass_per_table")) {
            for (Unique aKey : all_keys) {
                boolean inTable = true;
                String field = null;
                for (Field f : aKey.getFields()) {
                    if (e.getFields().contains(f)) continue;
                    inTable = false;
                    field = f.getName();
                }
                if (inTable) {
                    table_keys.add(aKey);
                    continue;
                }
                logger.warn((Object)("key " + aKey + " cannot be enforced on entity " + e.getName() + ": column '" + field + "' is not in the subclass table."));
            }
        }
        return table_keys;
    }

    public Field getXrefField(Model model, Field e) throws Exception {
        return e.getXrefEntity().getField(e.getXrefFieldName());
    }

    public FieldType getFieldType(Model model, Field field) throws Exception {
        FieldType type = field.getType();
        if (type instanceof XrefField || type instanceof MrefField) {
            Field f_ref = field.getXrefField();
            return this.getFieldType(model, f_ref);
        }
        return type;
    }

    public static String getJavaName(String name) {
        return GeneratorHelper.getJavaName(name, true);
    }

    public static String getJavaName(String name, boolean doFirstToUpper) {
        if (name == null) {
            return " NULL ";
        }
        String[] split = name.split("_");
        StringBuilder strBuilder = new StringBuilder();
        for (int i = 0; i < split.length; ++i) {
            if (i > 0) {
                strBuilder.append('_');
            }
            if (split[i].isEmpty()) continue;
            strBuilder.append(doFirstToUpper ? GeneratorHelper.firstToUpper(split[i]) : split[i]);
        }
        return strBuilder.toString();
    }

    public List<Entity> getSubclasses(Entity superclass, Model m) {
        ArrayList<Entity> result = new ArrayList<Entity>();
        result.add(superclass);
        String name = superclass.getName();
        for (Entity e : m.getEntities()) {
            if (!e.getParents().contains(name)) continue;
            result.addAll(this.getSubclasses(e, m));
        }
        return result;
    }

    public List<Entity> getSuperclasses(Entity subclass, Model m) {
        ArrayList<Entity> result = new ArrayList<Entity>(subclass.getAllAncestors());
        result.add(subclass);
        return result;
    }

    public String pluralOf(String string) {
        return string + "s";
    }

    public String parseQueryOperator(String label) {
        if (label.equals("EQUALS")) {
            return "EQUALS";
        }
        if (label.equals("IN")) {
            return "IN";
        }
        if (label.equals("LESS")) {
            return "LESS";
        }
        if (label.equals("LESS_EQUAL")) {
            return "LESS_EQUAL";
        }
        if (label.equals("GREATER")) {
            return "GREATER";
        }
        if (label.equals("GREATER_EQUAL")) {
            return "GREATER_EQUAL";
        }
        if (label.equals("LIKE")) {
            return "LIKE";
        }
        if (label.equals("NOT")) {
            return "NOT";
        }
        if (label.equals("LIMIT")) {
            return "LIMIT";
        }
        if (label.equals("OFFSET")) {
            return "OFFSET";
        }
        if (label.equals("SORTASC")) {
            return "SORTASC";
        }
        if (label.equals("SORTDESC")) {
            return "SORTDESC";
        }
        if (label.equals("NESTED")) {
            return "NESTED";
        }
        if (label.equals("LAST")) {
            return "LAST";
        }
        return "UNKNOWN";
    }

    public static String escapeXml(String nonXml) {
        return StringEscapeUtils.escapeXml((String)nonXml);
    }

    public String getImports(Model m, Entity e, String subpackage, String suffix) throws MolgenisModelException {
        String sfx = suffix;
        String subPkg = subpackage;
        if (sfx == null) {
            sfx = "";
        }
        if (subPkg != null) {
            if (!(subPkg = subPkg.trim()).equals("")) {
                if (!subPkg.startsWith(".")) {
                    subPkg = "." + subPkg;
                }
                if (!subPkg.endsWith(".")) {
                    subPkg = subPkg + ".";
                }
            } else {
                subPkg = ".";
            }
        } else {
            subPkg = ".";
        }
        ArrayList<String> imports = new ArrayList<String>();
        for (Field f : e.getAllFields()) {
            String fullClassName;
            if (!(f.getType() instanceof XrefField) && !(f.getType() instanceof MrefField) || imports.contains(fullClassName = f.getXrefEntity().getNamespace() + subPkg + GeneratorHelper.getJavaName(f.getXrefEntityName()) + sfx)) continue;
            imports.add(fullClassName);
        }
        String fullClassName = e.getNamespace() + subPkg + GeneratorHelper.getJavaName(e.getName()) + sfx;
        if (!imports.contains(fullClassName)) {
            imports.add(fullClassName);
        }
        StringBuilder strBuilder = new StringBuilder();
        for (String i : imports) {
            strBuilder.append("import ").append(i).append(";\n");
        }
        return strBuilder.toString();
    }

    public String getTypeFieldName() {
        return "__Type";
    }
}

