/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.generators.doc;

import freemarker.template.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.molgenis.MolgenisOptions;
import org.molgenis.generators.Generator;
import org.molgenis.model.MolgenisModel;
import org.molgenis.model.elements.Entity;
import org.molgenis.model.elements.Model;

public class FileFormatDocGen
extends Generator {
    private static final Logger logger = Logger.getLogger(FileFormatDocGen.class);

    @Override
    public String getDescription() {
        return "Generates one documentation file describing all entities.";
    }

    @Override
    public void generate(Model model, MolgenisOptions options) throws Exception {
        if (!options.generate_tests) {
            Template template = this.createTemplate("/" + this.getClass().getSimpleName() + ".java.ftl");
            Map<String, Object> templateArgs = this.createTemplateArguments(options);
            File target = new File(this.getDocumentationPath(options) + "/fileformat.html");
            boolean created = target.getParentFile().mkdirs();
            if (!created && !target.getParentFile().exists()) {
                throw new IOException("could not create " + target.getParentFile());
            }
            List<Entity> entityList = model.getEntities();
            entityList = MolgenisModel.sortEntitiesByDependency(entityList, model);
            templateArgs.put("model", model);
            templateArgs.put("entities", entityList);
            FileOutputStream targetOut = new FileOutputStream(target);
            template.process(templateArgs, (Writer)new OutputStreamWriter((OutputStream)targetOut, Charset.forName("UTF-8")));
            ((OutputStream)targetOut).close();
            logger.info((Object)("generated " + target));
        }
    }
}

