/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.molgenis.MolgenisOptions;
import org.molgenis.fieldtypes.EnumField;
import org.molgenis.fieldtypes.IntField;
import org.molgenis.fieldtypes.MrefField;
import org.molgenis.fieldtypes.StringField;
import org.molgenis.fieldtypes.TextField;
import org.molgenis.fieldtypes.XrefField;
import org.molgenis.model.MolgenisModelException;
import org.molgenis.model.elements.Entity;
import org.molgenis.model.elements.Field;
import org.molgenis.model.elements.Form;
import org.molgenis.model.elements.Model;
import org.molgenis.model.elements.Module;
import org.molgenis.model.elements.Unique;
import org.molgenis.model.elements.View;
import org.molgenis.util.Pair;

public class MolgenisModelValidator {
    private static final Logger logger = Logger.getLogger((String)MolgenisModelValidator.class.getSimpleName());
    private static final String[] HSQL_KEYWORDS = new String[]{"ALIAS", "ALTER", "AUTOCOMMIT", "CALL", "CHECKPOINT", "COMMIT", "CONNECT", "CREATE", "COLLATION", "COUNT", "DATABASE", "DEFRAG", "DELAY", "DELETE", "DISCONNECT", "DROP", "END", "EXPLAIN", "EXTRACT", "GRANT", "IGNORECASE", "INDEX", "INSERT", "INTEGRITY", "LOGSIZE", "PASSWORD", "POSITION", "PLAN", "PROPERTY", "READONLY", "REFERENTIAl", "REVOKE", "ROLE", "ROLLBACK", "SAVEPOINT", "SCHEMA", "SCRIPT", "SCRIPTFORMAT", "SELECT", "SEQUENCE", "SET", "SHUTDOWN", "SOURCE", "TABLE", "TRIGGER", "UPDATE", "USER", "VIEW", "WRITE"};
    private static final String[] MYSQL_KEYWORDS = new String[]{"Type", "ADD", "ALL", "ALTER", "ANALYZE", "AND", "AS", "ASC", "ASENSITIVE", "BEFORE", "BETWEEN", "BIGINT", "BINARY", "BLOB", "BOTH", "BY", "CALL", "CASCADE", "CASE", "CHANGE", "CHAR", "CHARACTER", "CHECK", "COLLATE", "COLUMN", "CONDITION", "CONNECTION", "CONSTRAINT", "CONTINUE", "CONVERT", "CREATE", "CROSS", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DATABASE", "DATABASES", "DAY_HOUR", "DAY_MICROSECOND", "DAY_MINUTE", "DAY_SECOND", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DELAYED", "DELETE", "DESC", "DESCRIBE", "DETERMINISTIC", "DISTINCT", "DISTINCTROW", "DIV", "DOUBLE", "DROP", "DUAL", "EACH", "ELSE", "ELSEIF", "ENCLOSED", "ESCAPED", "EXISTS", "EXIT", "EXPLAIN", "FALSE", "FETCH", "FLOAT", "FLOAT4", "FLOAT8", "FOR", "FORCE", "FOREIGN", "FROM", "FULLTEXT", "GRANT", "GROUP", "HAVING", "HIGH_PRIORITY", "HOUR_MICROSECOND", "HOUR_MINUTE", "HOUR_SECOND", "IF", "IGNORE", "IN", "INDEX", "INFILE", "INNER", "INOUT", "INSENSITIVE", "INSERT", "INT", "INT1", "INT2", "INT3", "INT4", "INT8", "INTEGER", "INTERVAL", "INTO", "IS", "ITERATE", "JOIN", "KEY", "KEYS", "KILL", "LEADING", "LEAVE", "LEFT", "LIKE", "LIMIT", "LINES", "LOAD", "LOCALTIME", "LOCALTIMESTAMP", "LOCK", "LONG", "LONGBLOB", "LONGTEXT", "LOOP", "LOW_PRIORITY", "MATCH", "MEDIUMBLOB", "MEDIUMINT", "MEDIUMTEXT", "MIDDLEINT", "MINUTE_MICROSECOND", "MINUTE_SECOND", "MOD", "MODIFIES", "NATURAL", "NOT", "NO_WRITE_TO_BINLOG", "NULL", "NUMERIC", "ON", "OPTIMIZE", "OPTION", "OPTIONALLY", "OR", "ORDER", "OUT", "OUTER", "OUTFILE", "PRECISION", "PRIMARY", "PROCEDURE", "PURGE", "RAID0", "READ", "READS", "REAL", "REFERENCES", "REGEXP", "RELEASE", "RENAME", "REPEAT", "REPLACE", "REQUIRE", "RESTRICT", "RETURN", "REVOKE", "RIGHT", "RLIKE", "SCHEMA", "SCHEMAS", "SECOND_MICROSECOND", "SELECT", "SENSITIVE", "SEPARATOR", "SET", "SHOW", "SMALLINT", "SONAME", "SPATIAL", "SPECIFIC", "SQL", "SQLEXCEPTION", "SQLSTATE", "SQLWARNING", "SQL_BIG_RESULT", "SQL_CALC_FOUND_ROWS", "SQL_SMALL_RESULT", "SSL", "STARTING", "STRAIGHT_JOIN", "TABLE", "TERMINATED", "THEN", "TINYBLOB", "TINYINT", "TINYTEXT", "TO", "TRAILING", "TRIGGER", "TRUE", "UNDO", "UNION", "UNIQUE", "UNLOCK", "UNSIGNED", "UPDATE", "USAGE", "USE", "USING", "UTC_DATE", "UTC_TIME", "UTC_TIMESTAMP", "VALUES", "VARBINARY", "VARCHAR", "VARCHARACTER", "VARYING", "WHEN", "WHERE", "WHILE", "WITH", "WRITE", "X509", "XOR", "YEAR_MONTH", "ZEROFILL"};
    private static final String[] JAVA_KEYWORDS = new String[]{"abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while"};
    private static final String[] JAVASCRIPT_KEYWORDS = new String[]{"function"};
    private static final String[] ORACLE_KEYWORDS = new String[]{"ACCESS", "ELSE", "MODIFY", "START", "ADD", "EXCLUSIVE", "NOAUDIT", "SELECT", "ALL", "EXISTS", "NOCOMPRESS", "SESSION", "ALTER", "FILE", "NOT", "SET", "AND", "FLOAT", "NOTFOUND", "SHARE", "ANY", "FOR", "NOWAIT", "SIZE", "ARRAYLEN", "FROM", "NULL", "SMALLINT", "AS", "GRANT", "NUMBER", "SQLBUF", "ASC", "GROUP", "OF", "SUCCESSFUL", "AUDIT", "HAVING", "OFFLINE", "SYNONYM", "BETWEEN", "IDENTIFIED", "ON", "SYSDATE", "BY", "IMMEDIATE", "ONLINE", "TABLE", "CHAR", "IN", "OPTION", "THEN", "CHECK", "INCREMENT", "OR", "TO", "CLUSTER", "INDEX", "ORDER", "TRIGGER", "COLUMN", "INITIAL", "PCTFREE", "UID", "COMMENT", "INSERT", "PRIOR", "UNION", "COMPRESS", "INTEGER", "PRIVILEGES", "UNIQUE", "CONNECT", "INTERSECT", "PUBLIC", "UPDATE", "CREATE", "INTO", "RAW", "USER", "CURRENT", "IS", "RENAME", "VALIDATE", "DATE", "LEVEL", "RESOURCE", "VALUES", "DECIMAL", "LIKE", "REVOKE", "VARCHAR", "DEFAULT", "LOCK", "ROW", "VARCHAR2", "DELETE", "LONG", "ROWID", "VIEW", "DESC", "MAXEXTENTS", "ROWLABEL", "WHENEVER", "DISTINCT", "MINUS", "ROWNUM", "WHERE", "DROP", "MODE", "ROWS", "WITH"};

    public static void validate(Model model, MolgenisOptions options) throws MolgenisModelException {
        logger.debug((Object)"validating model and adding defaults:");
        MolgenisModelValidator.validateNamesAndReservedWords(model, options);
        MolgenisModelValidator.validateExtendsAndImplements(model);
        if (options.object_relational_mapping.equals("subclass_per_table")) {
            MolgenisModelValidator.addTypeFieldInSubclasses(model);
        }
        MolgenisModelValidator.validateKeys(model);
        MolgenisModelValidator.addXrefLabelsToEntities(model);
        MolgenisModelValidator.validatePrimaryKeys(model);
        MolgenisModelValidator.validateForeignKeys(model);
        MolgenisModelValidator.validateViews(model);
        MolgenisModelValidator.validateOveride(model);
        MolgenisModelValidator.correctXrefCaseSensitivity(model);
        MolgenisModelValidator.moveMrefsFromInterfaceAndCopyToSubclass(model);
        MolgenisModelValidator.createLinkTablesForMrefs(model, options);
        MolgenisModelValidator.copyDefaultXrefLabels(model);
        MolgenisModelValidator.copyDecoratorsToSubclass(model);
        if (options.object_relational_mapping.equals("class_per_table")) {
            MolgenisModelValidator.addInterfaces(model);
        }
        MolgenisModelValidator.copyFieldsToSubclassToEnforceConstraints(model);
        MolgenisModelValidator.validateNameSize(model, options);
    }

    public static void moveMrefsFromInterfaceAndCopyToSubclass(Model model) throws MolgenisModelException {
        logger.debug((Object)"copy fields to subclass for constrain checking...");
        for (Entity entity : model.getEntities()) {
            for (Entity iface : entity.getImplements()) {
                for (Field mref : iface.getFieldsOf(new MrefField())) {
                    Field f = new Field(mref);
                    f.setEntity(entity);
                    String mrefName = entity.getName() + "_" + f.getName();
                    if (mrefName.length() > 30) {
                        mrefName = mrefName.substring(0, 25) + Integer.toString(mrefName.hashCode()).substring(0, 5);
                    }
                    f.setMrefName(mrefName);
                    entity.addField(0, f);
                }
            }
        }
        for (Entity entity : model.getEntities()) {
            if (!entity.isAbstract()) continue;
            for (Field mref : entity.getFieldsOf(new MrefField())) {
                entity.removeField(mref);
            }
        }
    }

    public static void validateOveride(Model model) {
    }

    public static void validateNameSize(Model model, MolgenisOptions options) throws MolgenisModelException {
        for (Entity e : model.getEntities()) {
            if (e.getName().length() > 30) {
                throw new MolgenisModelException(String.format("table name %s is longer than %d", e.getName(), 30));
            }
            for (Field f : e.getFields()) {
                if (f.getName().length() <= 30) continue;
                throw new MolgenisModelException(String.format("field name %s is longer than %d", f.getName(), 30));
            }
        }
    }

    public static void validateHideFields(Model model) throws MolgenisModelException {
        for (Form form : model.getUserinterface().getAllForms()) {
            List<String> hideFields = form.getHideFields();
            for (String fieldName : hideFields) {
                Entity entity = form.getEntity();
                Field field = entity.getAllField(fieldName);
                if (field == null) {
                    throw new MolgenisModelException("error in hide_fields for form name=" + form.getName() + ": cannot find field '" + fieldName + "' in form entity='" + entity.getName() + "'");
                }
                if (form.getReadOnly() || field.isNillable() || field.isAuto() || !field.getDefaultValue().equals("")) continue;
                logger.warn((Object)("you can get trouble with hiding field '" + fieldName + "' for form name=" + form.getName() + ": record is not null and doesn't have a default value (unless decorator fixes this!"));
            }
        }
    }

    public static void addXrefLabelsToEntities(Model model) throws MolgenisModelException {
        for (Entity e : model.getEntities()) {
            if (e.getXrefLabels() != null) continue;
            ArrayList<String> result = new ArrayList<String>();
            if (e.getAllKeys().size() > 1) {
                for (Field f : e.getAllKeys().get(1).getFields()) {
                    result.add(f.getName());
                }
                e.setXrefLabels(result);
            } else if (e.getAllKeys().size() > 0) {
                for (Field f : e.getAllKeys().get(0).getFields()) {
                    result.add(f.getName());
                }
                e.setXrefLabels(result);
            }
            logger.debug((Object)("added default xref_label=" + e.getXrefLabels() + " to entity=" + e.getName()));
        }
    }

    public static void validatePrimaryKeys(Model model) throws MolgenisModelException {
        for (Entity e : model.getEntities()) {
            if (e.isAbstract() || e.getKeys().size() != 0) continue;
            throw new MolgenisModelException("entity '" + e.getName() + " doesn't have a primary key defined ");
        }
    }

    public static void copyDefaultXrefLabels(Model model) throws MolgenisModelException {
        for (Entity e : model.getEntities()) {
            for (Field f : e.getFields()) {
                Entity xref_entity;
                if (!(f.getType() instanceof XrefField) && !(f.getType() instanceof MrefField) || f.getXrefLabelNames().size() <= 0 || !f.getXrefLabelNames().get(0).equals(f.getXrefFieldName()) || (xref_entity = f.getXrefEntity()).getXrefLabels() == null) continue;
                logger.debug((Object)("copying xref_label " + xref_entity.getXrefLabels() + " from " + f.getXrefEntityName() + " to field " + f.getEntity().getName() + "." + f.getName()));
                f.setXrefLabelNames(xref_entity.getXrefLabels());
            }
        }
    }

    public static void addTypeFieldInSubclasses(Model model) throws MolgenisModelException {
        logger.debug((Object)"add a 'type' field in subclasses to enable instanceof at database level...");
        for (Entity e : model.getEntities()) {
            if (e.isRootAncestor()) {
                Vector<Entity> subclasses = e.getAllDescendants();
                Vector<String> enumOptions = new Vector<String>();
                enumOptions.add(MolgenisModelValidator.firstToUpper(e.getName()));
                for (Entity subclass : subclasses) {
                    enumOptions.add(MolgenisModelValidator.firstToUpper(subclass.getName()));
                }
                if (e.getField("__Type") == null) {
                    Field type_field = new Field(e, new EnumField(), "__Type", "__Type", true, false, true, null);
                    type_field.setDescription("Subtypes have to be set to allow searching");
                    type_field.setHidden(true);
                    e.addField(0, type_field);
                }
                e.getField("__Type").setEnumOptions(enumOptions);
                continue;
            }
            e.removeField(e.getField("__Type"));
        }
    }

    public static void createLinkTablesForMrefs(Model model, MolgenisOptions options) throws MolgenisModelException {
        logger.debug((Object)"add linktable entities for mrefs...");
        for (Entity xref_entity_from : model.getEntities()) {
            for (Field xref_field_from : xref_entity_from.getImplementedFieldsOf(new MrefField())) {
                try {
                    Entity xref_entity_to = xref_field_from.getXrefEntity();
                    if (xref_entity_to.isImported()) continue;
                    Field xref_field_to = xref_field_from.getXrefField();
                    String mref_name = xref_field_from.getMrefName();
                    if (mref_name.length() > 30) {
                        throw new MolgenisModelException("mref_name cannot be longer then 30 characters, found: " + mref_name);
                    }
                    Entity mrefEntity = null;
                    try {
                        mrefEntity = model.getEntity(mref_name);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (mrefEntity == null) {
                        mrefEntity = new Entity(mref_name, mref_name, model.getDatabase());
                        mrefEntity.setNamespace(xref_entity_from.getNamespace());
                        mrefEntity.setAssociation(true);
                        mrefEntity.setDescription("Link table for many-to-many relationship '" + xref_entity_from.getName() + "." + xref_field_from.getName() + "'.");
                        mrefEntity.setSystem(true);
                        Field idField = new Field(mrefEntity, new IntField(), "autoid", "autoid", true, false, false, null);
                        idField.setHidden(true);
                        idField.setDescription("automatic id field to ensure ordering of mrefs");
                        mrefEntity.addField(idField);
                        mrefEntity.addKey(idField.getName(), "unique auto key to ensure ordering of mrefs");
                        Vector<String> unique = new Vector<String>();
                        Field field = new Field(mrefEntity, new XrefField(), xref_field_from.getMrefRemoteid(), null, false, false, false, null);
                        field.setXRefVariables(xref_entity_to.getName(), xref_field_to.getName(), xref_field_from.getXrefLabelNames());
                        if (xref_field_from.isXrefCascade()) {
                            field.setXrefCascade(true);
                        }
                        mrefEntity.addField(field);
                        unique.add(field.getName());
                        for (Field key : xref_entity_from.getKeyFields(0)) {
                            field = new Field(mrefEntity, new XrefField(), xref_field_from.getMrefLocalid(), null, false, false, false, null);
                            field.setXRefVariables(xref_entity_from.getName(), key.getName(), null);
                            mrefEntity.addField(field);
                            unique.add(field.getName());
                        }
                        mrefEntity.addKey(unique, false, null);
                    } else {
                        Field xrefField = mrefEntity.getAllField(xref_field_to.getName());
                        if (xrefField != null) {
                            xrefField.setXrefLabelNames(xref_field_from.getXrefLabelNames());
                        }
                    }
                    xref_field_from.setMrefName(mrefEntity.getName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(-1);
                }
            }
        }
    }

    public static void validateViews(Model model) throws MolgenisModelException {
        for (View view : model.getViews()) {
            Vector<Entity> entities = new Vector<Entity>();
            Vector<Pair<Entity, Entity>> references = new Vector<Pair<Entity, Entity>>();
            for (String viewentity : view.getEntities()) {
                Entity entity = model.getEntity(viewentity);
                if (entity == null) {
                    throw new MolgenisModelException("Entity '" + viewentity + "' in view '" + view.getName() + "' does not exist");
                }
                entities.add(entity);
            }
            for (Entity entity : entities) {
                for (Field field : entity.getFields()) {
                    if (!(field.getType() instanceof XrefField)) continue;
                    Entity referenced = null;
                    try {
                        referenced = field.getXrefEntity();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    for (Entity other : entities) {
                        if (other.getName().equals(entity.getName()) || !other.getName().equals(referenced.getName())) continue;
                        references.add(new Pair<Entity, Entity>(entity, other));
                    }
                }
            }
            Vector<Object> viewentities = new Vector<Object>();
            for (Pair pair : references) {
                if (!viewentities.contains(pair.getA())) {
                    viewentities.add(pair.getA());
                }
                if (viewentities.contains(pair.getB())) continue;
                viewentities.add(pair.getB());
            }
        }
    }

    public static void validateForeignKeys(Model model) throws MolgenisModelException {
        logger.debug((Object)"validate xref_field and xref_label references...");
        for (Entity entity : model.getEntities()) {
            String entityname = entity.getName();
            for (Field field : entity.getFields()) {
                Entity xref_entity;
                String fieldname = field.getName();
                if (!(field.getType() instanceof XrefField) && !(field.getType() instanceof MrefField)) continue;
                String xref_entity_name = field.getXrefEntityName();
                String xref_field_name = field.getXrefFieldName();
                List<String> xref_label_names = field.getXrefLabelNames();
                if (xref_label_names.size() == 0) {
                    xref_label_names.add(field.getXrefFieldName());
                }
                if ((xref_entity = model.getEntity(xref_entity_name)) == null) {
                    throw new MolgenisModelException("xref entity '" + xref_entity_name + "' does not exist for field " + entityname + "." + fieldname);
                }
                if (xref_field_name == null || xref_field_name.equals("")) {
                    xref_field_name = xref_entity.getPrimaryKey().getName();
                    field.setXrefField(xref_field_name);
                    logger.debug((Object)("automatically set " + entityname + "." + fieldname + " xref_field=" + xref_field_name));
                }
                if (!xref_entity.getName().equals(field.getXrefEntityName())) {
                    throw new MolgenisModelException("xref entity '" + xref_entity_name + "' does not exist for field " + entityname + "." + fieldname + " (note: entity names are case-sensitive)");
                }
                if (xref_entity.isAbstract()) {
                    throw new MolgenisModelException("cannot refer to abstract xref entity '" + xref_entity_name + "' from field " + entityname + "." + fieldname);
                }
                Field xref_field = xref_entity.getField(xref_field_name, false, true, true);
                if (xref_field == null) {
                    throw new MolgenisModelException("xref field '" + xref_field_name + "' does not exist for field " + entityname + "." + fieldname);
                }
                for (String xref_label_name : xref_label_names) {
                    Field xref_label = null;
                    xref_label = xref_label_name.contains(".") ? model.findField(xref_label_name) : xref_entity.getAllField(xref_label_name);
                    if (xref_label == null) {
                        StringBuilder validFieldsBuilder = new StringBuilder();
                        Map<String, List<Field>> candidates = field.allPossibleXrefLabels();
                        if (candidates.size() == 0) {
                            throw new MolgenisModelException("xref label '" + xref_label_name + "' does not exist for field " + entityname + "." + fieldname + ". \nCouldn't find suitable secondary keys to use as xref_label. \nDid you set a unique=\"true\" or <unique fields=\" ...>?");
                        }
                        for (Map.Entry<String, List<Field>> entry : candidates.entrySet()) {
                            String key = entry.getKey();
                            if (xref_label_name.equals(key)) {
                                List<Field> value = entry.getValue();
                                xref_label = value.get(value.size() - 1);
                            }
                            validFieldsBuilder.append(',').append(key);
                        }
                        if (xref_label != null) continue;
                        throw new MolgenisModelException("xref label '" + xref_label_name + "' does not exist for field " + entityname + "." + fieldname + ". Valid labels include " + validFieldsBuilder.toString());
                    }
                    if (xref_label_name.equals(xref_field_name) || field.allPossibleXrefLabels().keySet().contains(xref_label_name)) continue;
                    String validLabels = StringUtils.join(field.allPossibleXrefLabels().keySet(), (char)',');
                    throw new MolgenisModelException("xref label '" + xref_label_name + "' for " + entityname + "." + fieldname + " is not part a secondary key. Valid labels are " + validLabels + "\nDid you set a unique=\"true\" or <unique fields=\" ...>?");
                }
                if (xref_field.getType() instanceof TextField) {
                    throw new MolgenisModelException("xref field '" + xref_field_name + "' is of illegal type 'TEXT' for field " + entityname + "." + fieldname);
                }
                boolean isunique = false;
                for (Unique unique : xref_entity.getAllKeys()) {
                    for (Field keyfield : unique.getFields()) {
                        if (!keyfield.getName().equals(xref_field_name)) continue;
                        isunique = true;
                    }
                }
                if (isunique) continue;
                throw new MolgenisModelException("xref pointer '" + xref_entity_name + "." + xref_field_name + "' is a non-unique field for field " + entityname + "." + fieldname + "\n" + xref_entity.toString());
            }
        }
    }

    public static void validateKeys(Model model) throws MolgenisModelException {
        logger.debug((Object)"validate the fields used in 'unique' constraints...");
        for (Entity entity : model.getEntities()) {
            String entityname = entity.getName();
            int autocount = 0;
            for (Field field : entity.getAllFields()) {
                String fieldname = field.getName();
                if (field.isAuto() && field.getType() instanceof IntField) {
                    ++autocount;
                    boolean iskey = false;
                    for (Unique unique : entity.getAllKeys()) {
                        for (Field keyfield : unique.getFields()) {
                            if (keyfield.getName() == null) {
                                throw new MolgenisModelException("unique field '" + fieldname + "' is not known in entity " + entityname);
                            }
                            if (!keyfield.getName().equals(field.getName())) continue;
                            iskey = true;
                        }
                    }
                    if (!iskey) {
                        throw new MolgenisModelException("there can be only one auto column and it must be the primary key for field '" + entityname + "." + fieldname + "'");
                    }
                }
                if (!(field.getType() instanceof EnumField) || field.getDefaultValue() == null || "".equals(field.getDefaultValue()) || field.getEnumOptions().contains(field.getDefaultValue())) continue;
                throw new MolgenisModelException("default value '" + field.getDefaultValue() + "' is not in enum_options for field '" + entityname + "." + fieldname + "'");
            }
            if (autocount > 1) {
                throw new MolgenisModelException("there should be only one auto column and it must be the primary key for entity '" + entityname + "'");
            }
            if (entity.isAbstract() || autocount >= true) continue;
            throw new MolgenisModelException("there should be one auto column for each root entity and it must be the primary key for entity '" + entityname + "'");
        }
    }

    public static void validateExtendsAndImplements(Model model) throws MolgenisModelException {
        logger.debug((Object)"validate 'extends' and 'implements' relationships...");
        for (Entity entity : model.getEntities()) {
            Vector<Entity> ifaces = entity.getAllImplements();
            for (Entity iface : ifaces) {
                if (!iface.isAbstract()) {
                    throw new MolgenisModelException(entity.getName() + " cannot implement " + iface.getName() + " because it is not abstract");
                }
                try {
                    Field pkeyField = null;
                    if (iface.getKeys().size() != 1 || entity.getField((pkeyField = iface.getKeyFields(0).get(0)).getName()) != null) continue;
                    Field field = new Field(pkeyField);
                    field.setEntity(entity);
                    field.setAuto(pkeyField.isAuto());
                    field.setNillable(pkeyField.isNillable());
                    field.setReadonly(pkeyField.isReadOnly());
                    field.setXRefVariables(iface.getName(), pkeyField.getName(), null);
                    field.setHidden(true);
                    logger.debug((Object)("copy primary key " + field.getName() + " from interface " + iface.getName() + " to " + entity.getName()));
                    entity.addField(field);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new MolgenisModelException(e.getMessage());
                }
            }
            Vector<String> parents = entity.getParents();
            if (parents.size() == 0) continue;
            Entity parent = model.getEntity(parents.get(0));
            if (parent == null) {
                throw new MolgenisModelException("superclass '" + parents.get(0) + "' for '" + entity.getName() + "' is missing");
            }
            if (parent.isAbstract()) {
                throw new MolgenisModelException(entity.getName() + " cannot extend " + parents.get(0) + " because superclas " + parents.get(0) + " is abstract (use implements)");
            }
            if (entity.isAbstract()) {
                throw new MolgenisModelException(entity.getName() + " cannot extend " + parents.get(0) + " because " + entity.getName() + " itself is abstract");
            }
            if (parent.getKeys().size() != 0) continue;
        }
    }

    public static void addInterfaces(Model model) throws MolgenisModelException {
        logger.debug((Object)"add root entities for interfaces...");
        for (Entity entity : model.getEntities()) {
            if (!entity.isRootAncestor()) continue;
            Entity rootAncestor = entity;
            if (!entity.isAbstract()) {
                rootAncestor = new Entity("_" + entity.getName() + "Interface", entity.getName(), model.getDatabase());
                rootAncestor.setDescription("Identity map table for " + entity.getName() + " and all its subclasses. " + "For each row that is added to " + entity.getName() + " or one of its subclasses, first a row must be added to this table to get a valid primary key value.");
                Vector<Field> keyfields = entity.getKey(0).getFields();
                Vector<String> keyfields_copy = new Vector<String>();
                for (Field f : keyfields) {
                    Field key_field = new Field(rootAncestor, f.getType(), f.getName(), f.getName(), f.isAuto(), f.isNillable(), f.isReadOnly(), f.getDefaultValue());
                    key_field.setDescription("Primary key field unique in " + entity.getName() + " and its subclasses.");
                    if (key_field.getType() instanceof StringField) {
                        key_field.setVarCharLength(key_field.getVarCharLength());
                    }
                    rootAncestor.addField(key_field);
                    keyfields_copy.add(key_field.getName());
                    if (!f.isAuto()) continue;
                }
                rootAncestor.addKey(keyfields_copy, entity.getKey(0).isSubclass(), null);
                Vector<String> parents = new Vector<String>();
                parents.add(rootAncestor.getName());
                entity.setParents(parents);
            }
            Vector<Entity> subclasses = entity.getAllDescendants();
            Vector<String> enumOptions = new Vector<String>();
            enumOptions.add(entity.getName());
            for (Entity subclass : subclasses) {
                enumOptions.add(subclass.getName());
            }
            Field type_field = new Field(rootAncestor, new EnumField(), "__Type", "__Type", true, false, false, null);
            type_field.setDescription("Subtypes of " + entity.getName() + ". Have to be set to allow searching");
            type_field.setEnumOptions(enumOptions);
            type_field.setHidden(true);
            rootAncestor.addField(0, type_field);
        }
    }

    public static void validateNamesAndReservedWords(Model model, MolgenisOptions options) throws MolgenisModelException {
        logger.debug((Object)"check for JAVA and SQL reserved words...");
        HashSet<String> keywords = new HashSet<String>();
        keywords.addAll(Arrays.asList(JAVA_KEYWORDS));
        keywords.addAll(Arrays.asList(JAVASCRIPT_KEYWORDS));
        keywords.addAll(Arrays.asList(ORACLE_KEYWORDS));
        keywords.addAll(Arrays.asList(MYSQL_KEYWORDS));
        if (model.getName().contains(" ")) {
            throw new MolgenisModelException("model name '" + model.getName() + "' illegal: it cannot contain spaces. Use 'label' if you want to show a name with spaces.");
        }
        for (Module m : model.getModules()) {
            if (!m.getName().contains(" ")) continue;
            throw new MolgenisModelException("module name '" + m.getName() + "' illegal: it cannot contain spaces. Use 'label' if you want to show a name with spaces.");
        }
        for (Entity e : model.getEntities()) {
            if (e.getName().contains(" ")) {
                throw new MolgenisModelException("entity name '" + e.getName() + "' cannot contain spaces. Use 'label' if you want to show a name with spaces.");
            }
            if (keywords.contains(e.getName().toUpperCase()) || keywords.contains(e.getName().toLowerCase())) {
                throw new MolgenisModelException("entity name '" + e.getName() + "' illegal:" + e.getName() + " is a reserved JAVA and/or SQL word and cannot be used for entity name");
            }
            for (Field f : e.getFields()) {
                if (f.getName().contains(" ")) {
                    throw new MolgenisModelException("field name '" + e.getName() + "." + f.getName() + "' cannot contain spaces. Use 'label' if you want to show a name with spaces.");
                }
                if (keywords.contains(f.getName().toUpperCase()) || keywords.contains(f.getName().toLowerCase())) {
                    throw new MolgenisModelException("field name '" + e.getName() + "." + f.getName() + "' illegal: " + f.getName() + " is a reserved JAVA and/or SQL word");
                }
                if (!(f.getType() instanceof XrefField) && !(f.getType() instanceof MrefField)) continue;
                String xref_entity = f.getXrefEntityName();
                if (xref_entity != null && (keywords.contains(xref_entity.toUpperCase()) || keywords.contains(xref_entity.toLowerCase()))) {
                    throw new MolgenisModelException("xref_entity reference from field '" + e.getName() + "." + f.getName() + "' illegal: " + xref_entity + " is a reserved JAVA and/or SQL word");
                }
                if (!(f.getType() instanceof MrefField)) continue;
                if (f.getMrefName() == null) {
                    String mrefEntityName = f.getEntity().getName() + "_" + f.getName();
                    if (mrefEntityName.length() > 30) {
                        mrefEntityName = mrefEntityName.substring(0, 25) + Integer.toString(mrefEntityName.hashCode()).substring(0, 5);
                    }
                    Entity mrefEntity = null;
                    try {
                        mrefEntity = model.getEntity(mrefEntityName);
                    }
                    catch (Exception exc) {
                        throw new MolgenisModelException("mref name for " + f.getEntity().getName() + "." + f.getName() + " not unique. Please use explicit mref_name=name setting");
                    }
                    if (mrefEntity != null && model.getEntity(mrefEntityName = mrefEntityName + "_mref") != null) {
                        mrefEntityName = mrefEntityName + "_" + Math.random();
                    }
                    f.setMrefName(mrefEntityName);
                }
                if (f.getMrefLocalid() == null) {
                    f.setMrefLocalid(f.getEntity().getName());
                }
                if (f.getMrefRemoteid() != null) continue;
                f.setMrefRemoteid(f.getName());
            }
        }
    }

    public static void correctXrefCaseSensitivity(Model model) throws MolgenisModelException {
        logger.debug((Object)"correct case of names in xrefs...");
        for (Entity e : model.getEntities()) {
            for (Field f : e.getFields()) {
                if (!(f.getType() instanceof XrefField) && !(f.getType() instanceof MrefField)) continue;
                try {
                    Entity xrefEntity = f.getXrefEntity();
                    f.setXRefEntity(xrefEntity.getName());
                    String xrefField = f.getXrefField().getName();
                    List<String> xrefLabels = f.getXrefLabelsTemp();
                    ArrayList<String> correctedXrefLabels = new ArrayList<String>();
                    for (String xrefLabel : xrefLabels) {
                        correctedXrefLabels.add(xrefEntity.getAllField(xrefLabel).getName());
                    }
                    f.setXRefVariables(xrefEntity.getName(), xrefField, correctedXrefLabels);
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void copyDecoratorsToSubclass(Model model) throws MolgenisModelException {
        logger.debug((Object)"copying decorators to subclasses...");
        for (Entity e : model.getEntities()) {
            if (e.getDecorator() != null) continue;
            for (Entity superClass : e.getImplements()) {
                if (superClass.getDecorator() == null) continue;
                e.setDecorator(superClass.getDecorator());
            }
            for (Entity superClass : e.getAllAncestors()) {
                if (superClass.getDecorator() == null) continue;
                e.setDecorator(superClass.getDecorator());
            }
        }
    }

    public static void copyFieldsToSubclassToEnforceConstraints(Model model) throws MolgenisModelException {
        logger.debug((Object)"copy fields to subclass for constrain checking...");
        for (Entity e : model.getEntities()) {
            if (!e.hasAncestor()) continue;
            for (Unique aKey : e.getKeys()) {
                for (Field f : aKey.getFields()) {
                    if (e.getField(f.getName()) != null) continue;
                    Field copy = new Field(f);
                    copy.setEntity(e);
                    copy.setAuto(f.isAuto());
                    e.addField(copy);
                    logger.debug((Object)(aKey.toString() + " cannot be enforced on " + e.getName() + ", copying " + f.getEntity().getName() + "." + f.getName() + " to subclass as " + copy.getName()));
                }
            }
        }
    }

    private static String firstToUpper(String string) {
        if (string == null) {
            return " NULL ";
        }
        if (string.length() > 0) {
            return string.substring(0, 1).toUpperCase() + string.substring(1);
        }
        return " ERROR[STRING EMPTY] ";
    }
}

