/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.mapdb.DB;
import org.mapdb.DBMaker;

public class HugeMap<K, V>
implements Map<K, V>,
Closeable {
    private final DB mapDB;
    private final File dbFile;
    private final Map<K, V> mapDBMap;

    public HugeMap() {
        try {
            this.dbFile = File.createTempFile("mapdb", "temp");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.mapDB = DBMaker.newFileDB((File)this.dbFile).transactionDisable().make();
        this.mapDBMap = this.mapDB.createHashMap("map").make();
    }

    @Override
    public int size() {
        return this.mapDBMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mapDBMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.mapDBMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.mapDBMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.mapDBMap.get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.mapDBMap.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.mapDBMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.mapDBMap.putAll(m);
    }

    @Override
    public void clear() {
        this.mapDBMap.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.mapDBMap.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.mapDBMap.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.mapDBMap.entrySet();
    }

    @Override
    public void close() throws IOException {
        this.mapDB.close();
        this.dbFile.delete();
    }

    public String toString() {
        return new HashMap<K, V>(this.mapDBMap).toString();
    }
}

