/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.mapdb.DB;
import org.mapdb.DBMaker;

public class HugeSet<E>
implements Set<E>,
Closeable {
    private final DB mapDB;
    private final File dbFile;
    private final Set<E> mapDBSet;

    public HugeSet() {
        try {
            this.dbFile = File.createTempFile("mapdb", "temp");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.mapDB = DBMaker.newFileDB((File)this.dbFile).transactionDisable().make();
        this.mapDBSet = this.mapDB.createHashSet("set").make();
    }

    @Override
    public int size() {
        return this.mapDBSet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mapDBSet.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.mapDBSet.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.mapDBSet.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.mapDBSet.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.mapDBSet.toArray(a);
    }

    @Override
    public boolean add(E e) {
        return this.mapDBSet.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.mapDBSet.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.mapDBSet.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.mapDBSet.addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.mapDBSet.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.mapDBSet.removeAll(c);
    }

    @Override
    public void clear() {
        this.mapDBSet.clear();
    }

    @Override
    public void close() throws IOException {
        this.mapDB.close();
        this.dbFile.delete();
    }
}

