/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import org.apache.log4j.Logger;
import org.molgenis.util.RScriptException;

public class RScript {
    public String R_COMMAND = "R CMD BATCH --vanilla --slave";
    private final Logger logger = Logger.getLogger((String)RScript.class.getSimpleName());
    private final StringBuffer script = new StringBuffer();
    private String error;
    private String output;
    private String result;

    public String getErrors() {
        return this.error;
    }

    public String getOutput() {
        return this.output;
    }

    public String getResult() {
        return this.result;
    }

    public String getR_COMMAND() {
        return this.R_COMMAND;
    }

    public void setR_COMMAND(String r_COMMAND) {
        this.R_COMMAND = r_COMMAND;
    }

    public void append(String command) {
        this.script.append(command + System.getProperty("line.separator"));
    }

    public void append(String command, Object ... args) {
        this.script.append(String.format(command, args) + System.getProperty("line.separator"));
    }

    public String execute() throws RScriptException {
        return this.execute(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(String scriptPathName) throws RScriptException {
        this.append("q(\"no\",status=0, FALSE)");
        String scriptCode = this.script.toString();
        String command = "";
        File inputfile = null;
        File outputfile = null;
        try {
            inputfile = scriptPathName == null ? File.createTempFile("run", ".R") : new File(scriptPathName);
            outputfile = File.createTempFile("run", ".output");
            try (OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(inputfile), Charset.forName("UTF-8"));){
                fw.write(scriptCode);
            }
            System.out.println("wrote script to file " + inputfile);
            command = System.getProperty("os.name").toLowerCase().indexOf("windows") == -1 ? command + this.R_COMMAND + " " + inputfile.getCanonicalPath() + " " + outputfile.getCanonicalPath() : command + this.R_COMMAND + " \"" + inputfile.getCanonicalPath() + "\" \"" + outputfile.getCanonicalPath() + "\"";
            this.logger.debug((Object)("Executing: " + command));
            Process process = Runtime.getRuntime().exec(command);
            process.waitFor();
            this.error = this.streamToString(process.getErrorStream());
            if (this.error.length() > 0) {
                this.logger.error((Object)("R script printed errors: " + this.error));
            }
            this.output = this.streamToString(process.getInputStream());
            if (this.error.length() > 0) {
                this.logger.debug((Object)("R script printed messages: " + this.output));
            }
            this.result = this.streamToString(new FileInputStream(outputfile));
            if (process.exitValue() > 0) {
                throw new Exception("" + process.exitValue());
            }
        }
        catch (Exception e) {
            this.logger.debug((Object)("Script failed: return code " + e.getMessage() + "\nScript:\n" + scriptCode + "\nOutput:\n" + this.result));
            throw new RScriptException(this.result);
        }
        this.logger.debug((Object)("Script completed succesfully.\nScript:\n" + scriptCode + "\nOutput:\n" + this.result));
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFile(String fromPath, String toPath) throws Exception {
        try (FileInputStream fis = new FileInputStream(fromPath);
             FileOutputStream fos = new FileOutputStream(toPath);){
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = fis.read(buf)) != -1) {
                fos.write(buf, 0, i);
            }
        }
    }

    public void deleteFile(String path) throws Exception {
        File toDelete = new File(path);
        boolean ok = toDelete.delete();
        if (!ok) {
            throw new IOException("failed to delete " + path);
        }
    }

    public String toString() {
        return this.script.toString();
    }

    private String streamToString(InputStream inputStream) throws IOException {
        String line;
        StringBuffer fileContents = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, Charset.forName("UTF-8")));
        while ((line = reader.readLine()) != null) {
            fileContents.append(line + "\n");
        }
        reader.close();
        inputStream.close();
        return fileContents.toString();
    }
}

