/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.molgenis.util.Tree;

public class SimpleTree<T extends Tree>
implements Tree<T>,
Serializable {
    private static final Logger logger = Logger.getLogger(SimpleTree.class);
    protected String name;
    private Object value;
    protected String parentName;
    protected Map<String, T> treeElements;
    static final long serialVersionUID = 7443849689931440159L;

    public SimpleTree(String name, T parent) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("name cannot be empty");
        }
        if (parent != null) {
            try {
                if (parent.get(name) != null) {
                    throw new IllegalArgumentException("elements already exists with name = '" + name + "'");
                }
            }
            catch (NullPointerException e) {
                logger.error((Object)"NullPointer in constructor op SimpleTree", (Throwable)e);
            }
        }
        this.name = name;
        if (parent == null) {
            this.treeElements = new LinkedHashMap<String, T>();
        } else {
            this.treeElements = parent.getTreeElements();
            this.parentName = parent.getName();
        }
        this.treeElements.put(name, this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("name cannot be empty");
        }
        this.treeElements.remove(this.getName());
        this.name = name;
        this.treeElements.put(name, this);
    }

    public void setName(String name, String url) {
        this.setName(name);
    }

    @Override
    public T get(String name) {
        return (T)((Tree)this.treeElements.get(name));
    }

    @Override
    public final T getParent() {
        if (this.parentName != null) {
            return (T)((Tree)this.treeElements.get(this.parentName));
        }
        return null;
    }

    @Override
    public void setParent(T parent) {
        if (parent != null && parent.get(this.name) != null) {
            throw new IllegalArgumentException(this.toString() + ".setParent(" + parent.toString() + ") failed: a element already exists with name = '" + this.name + "', being " + parent.get(this.name));
        }
        for (String ckey : this.treeElements.keySet()) {
            for (String pkey : parent.getTreeElements().keySet()) {
                if (!pkey.equals(ckey) || parent.getTreeElements().get(pkey).equals(this.treeElements.get(ckey))) continue;
                throw new IllegalArgumentException("setParent(" + parent.getName() + "): duplicate child '" + ckey + "'/'" + pkey + "'");
            }
        }
        for (String ckey : this.treeElements.keySet()) {
            if (parent.getTreeElements().containsValue(this.treeElements.get(ckey))) continue;
            parent.getTreeElements().put(ckey, this.treeElements.get(ckey));
        }
        this.treeElements = parent.getTreeElements();
        this.parentName = parent.getName();
    }

    @Override
    public T getRoot() {
        if (this.parentName == null) {
            return (T)this;
        }
        return (T)((Tree)this.getParent().getRoot());
    }

    @Override
    public final List<T> getAllChildren() {
        return this.getAllChildren(false);
    }

    @Override
    public final List<T> getAllChildren(boolean includeSelf) {
        ArrayList all_children = new ArrayList();
        if (includeSelf) {
            all_children.add(this);
        }
        for (Tree child : this.getChildren()) {
            all_children.add(child);
            all_children.addAll(child.getAllChildren());
        }
        return all_children;
    }

    @Override
    public Vector<T> getChildren() {
        Vector<Tree> children = new Vector<Tree>();
        for (Tree sc : this.treeElements.values()) {
            if (sc.getParent() == null || sc.getParent() != this) continue;
            children.add(sc);
        }
        return children;
    }

    @Override
    public T getChild(String name) {
        Tree child = (Tree)this.treeElements.get(name);
        if (child != null && child.getParent() != null && child.getParent().equals(this)) {
            return (T)child;
        }
        return null;
    }

    public String toString(boolean includeSubTree) {
        return this.toString(includeSubTree, 0);
    }

    @Override
    public String toString(boolean includeSubTree, int level) {
        StringBuilder strBuilder = new StringBuilder(this.toString());
        if (includeSubTree && this.getChildren().size() > 0) {
            String indent = "";
            for (int i = 0; i <= level; ++i) {
                indent = indent + "    ";
            }
            for (Tree element : this.getChildren()) {
                strBuilder.append('\n').append(indent).append(element.toString(true, level + 1)).append(',');
            }
            strBuilder.deleteCharAt(strBuilder.length() - 1);
        }
        return strBuilder.toString();
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public Map<String, T> getTreeElements() {
        return this.treeElements;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(name='" + this.getName() + "')";
    }

    @Override
    public boolean hasChildren() {
        return !this.getChildren().isEmpty();
    }

    @Override
    public boolean hasParent() {
        return this.getParent() != null;
    }

    public String getStringValue() {
        if (this.value == null) {
            return "";
        }
        return this.value.toString();
    }

    @Override
    public String getPath(String separator) {
        if (this.getParent() != null) {
            return this.getParent().getPath(separator) + separator + this.getName();
        }
        return this.getName();
    }

    public void remove() {
        for (Tree t : this.getAllChildren()) {
            this.treeElements.remove(t.getName());
        }
        this.treeElements.remove(this.getName());
    }
}

