/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.molgenis.util.cmdline.CmdLineException;
import org.molgenis.util.cmdline.CmdLineParser;
import org.molgenis.util.cmdline.Option;

public class MolgenisOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(MolgenisOptions.class);
    public static final String CLASS_PER_TABLE = "class_per_table";
    public static final String SUBCLASS_PER_TABLE = "subclass_per_table";
    public static final String HIERARCHY_PER_TABLE = "hierarchy_per_table";
    private String molgenis_properties = "";
    @Option(name="model_database", param=Option.Param.COLLECTION, type=Option.Type.REQUIRED_ARGUMENT, usage="File with data structure specification (in MOLGENIS DSL). Default: new ArrayList<String>()")
    public ArrayList<String> model_database = new ArrayList();
    @Option(name="import_model_database", param=Option.Param.COLLECTION, type=Option.Type.REQUIRED_ARGUMENT, usage="File with data structure specification (in MOLGENIS DSL). Default: new ArrayList<String>()")
    public ArrayList<String> import_model_database = new ArrayList();
    @Option(name="output_dir", param=Option.Param.DIRPATH, type=Option.Type.OPTIONAL_ARGUMENT, usage="Directory where all generated code is stored")
    public String output_dir = "generated";
    @Option(name="output_src", param=Option.Param.DIRPATH, type=Option.Type.REQUIRED_ARGUMENT, usage="Output-directory for the generated Java classes. Default: 'generated/java'")
    public String output_src = this.output_dir + "/java";
    @Option(name="output_hand", param=Option.Param.DIRPATH, type=Option.Type.REQUIRED_ARGUMENT, usage="Source directory for handwritten java. Default: 'handwritten/java'")
    public String output_hand = "handwritten/java";
    @Option(name="output_sql", param=Option.Param.DIRPATH, type=Option.Type.REQUIRED_ARGUMENT, usage="Output-directory for the generated sql files. Default: 'generated/sql'")
    public String output_sql = this.output_dir + "/sql";
    @Option(name="output_doc", param=Option.Param.DIRPATH, type=Option.Type.REQUIRED_ARGUMENT, usage="Output-directory for the generated documentation. Default: 'WebContent/generated-doc'")
    public String output_doc = "WebContent/generated-doc";
    @Option(name="output_web", param=Option.Param.DIRPATH, type=Option.Type.REQUIRED_ARGUMENT, usage="Output-directory for any generated web resources. Default: 'WebContent'")
    public String output_web = "WebContent";
    @Option(name="decorator_overriders", param=Option.Param.CLASS, type=Option.Type.OPTIONAL_ARGUMENT, usage="Points to an application package with overriding classes for entity decorators, mapped by name. Default: ''")
    public String decorator_overriders = "";
    @Option(name="db_filepath", param=Option.Param.DIRPATH, type=Option.Type.REQUIRED_ARGUMENT, usage="Path where the database should store file attachements. Default: 'data'")
    public String db_filepath = "data";
    @Option(name="object_relational_mapping", param=Option.Param.STRING, type=Option.Type.OPTIONAL_ARGUMENT, usage="Expert option: Choosing OR strategy. Either 'class_per_table', 'subclass_per_table', 'hierarchy_per_table'. Default: SUBCLASS_PER_TABLE")
    public String object_relational_mapping = "subclass_per_table";
    @Option(name="generate_persistence", param=Option.Param.BOOLEAN, type=Option.Type.OPTIONAL_ARGUMENT, usage="Expert option: Choosing whether persistence.xml is generated by molgenis (true) or supplied by user (false). Default: true")
    public boolean generate_persistence = true;
    @Option(name="generate_jpa", param=Option.Param.BOOLEAN, type=Option.Type.OPTIONAL_ARGUMENT, usage="Generate JPA related classes. Default: true")
    public boolean generate_jpa = true;
    @Option(name="jpa_use_sequence", param=Option.Param.BOOLEAN, type=Option.Type.OPTIONAL_ARGUMENT, usage="Expert option: Choosing whether sequence are used to generate primary key (true) or auto (false: default)")
    public boolean jpa_use_sequence = false;
    @Option(name="generate_db", param=Option.Param.BOOLEAN, type=Option.Type.OPTIONAL_ARGUMENT, usage="generate database. Default: true")
    public boolean generate_db = true;
    @Option(name="exclude_system", param=Option.Param.BOOLEAN, type=Option.Type.REQUIRED_ARGUMENT, usage="Expert option: Whether system tables should be excluded from generation. Default: true")
    public boolean exclude_system = true;
    @Option(name="generate_doc", param=Option.Param.BOOLEAN, type=Option.Type.OPTIONAL_ARGUMENT, usage="Should documentation be generated. Default: true.")
    public boolean generate_doc = true;
    @Option(name="generate_entityio", param=Option.Param.BOOLEAN, type=Option.Type.OPTIONAL_ARGUMENT, usage="Should entity importers and exporters be generated. Default: true.")
    public boolean generate_entityio = true;
    @Option(name="generate_tests", param=Option.Param.BOOLEAN, type=Option.Type.OPTIONAL_ARGUMENT, usage="Should test code for generated code be generated. Default: false.")
    public boolean generate_tests = false;
    @Option(name="generate_model", param=Option.Param.BOOLEAN, type=Option.Type.OPTIONAL_ARGUMENT, usage="Generate any SQL related classes. Default: true")
    public boolean generate_model = true;
    @Option(name="delete_generated_folder", param=Option.Param.BOOLEAN, type=Option.Type.OPTIONAL_ARGUMENT, usage="delete generated Folder before generators are executed. Default: true")
    public boolean delete_generated_folder = true;
    @Option(name="authorizable", param=Option.Param.COLLECTION, type=Option.Type.OPTIONAL_ARGUMENT, usage="For use in molgenis_apps! Tells the generator on which entities to append an implements='Authorizable'. Default: new ArrayList<String>()")
    public ArrayList<String> authorizable = new ArrayList();
    @Option(name="disable_decorators", param=Option.Param.BOOLEAN, type=Option.Type.OPTIONAL_ARGUMENT, usage="disables all decorators for generated test")
    public boolean disable_decorators = false;
    @Option(name="block_webspiders", param=Option.Param.BOOLEAN, type=Option.Type.OPTIONAL_ARGUMENT, usage="Expert option: Block webcrawler user agents in FrontController")
    public boolean block_webspiders = false;
    @Option(name="generate_jpa_repository_source", param=Option.Param.BOOLEAN, type=Option.Type.OPTIONAL_ARGUMENT, usage="generate JpaRepositorySource. Default: false")
    public boolean generate_jpa_repository_source = false;
    public String path = "";

    public MolgenisOptions() {
    }

    public Map<String, Object> getOptionsAsMap() throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Field[] fields = this.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].isAnnotationPresent(Option.class)) continue;
            Option opt = fields[i].getAnnotation(Option.class);
            if (opt.param() == Option.Param.PASSWORD) {
                result.put(opt.name(), "xxxxxx");
                continue;
            }
            result.put(opt.name(), fields[i].get(this));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MolgenisOptions(String propertiesFile) throws FileNotFoundException, IOException, CmdLineException {
        this.molgenis_properties = propertiesFile;
        Properties props = new Properties();
        FileInputStream is = null;
        try {
            is = new FileInputStream(propertiesFile.trim());
            props.load(is);
        }
        catch (FileNotFoundException e) {
            try {
                InputStream is2 = Thread.currentThread().getContextClassLoader().getResourceAsStream(propertiesFile.trim());
                try {
                    props.load(is2);
                }
                catch (Exception e2) {
                    throw new IOException("couldn't find file " + new File(propertiesFile).getAbsolutePath());
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        IOUtils.closeQuietly((InputStream)is);
        CmdLineParser parser = new CmdLineParser(this);
        parser.parse(props);
        this.molgenis_properties = propertiesFile;
        logger.debug((Object)"parsed properties file.");
    }

    public MolgenisOptions(Properties properties) {
        try {
            CmdLineParser parser = new CmdLineParser(this);
            parser.parse(properties);
            logger.debug((Object)"parsed properties file.");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot find property file: " + e.getMessage());
        }
    }

    public String toString() {
        try {
            return new CmdLineParser(this).toString(this);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (CmdLineException e) {
            e.printStackTrace();
        }
        return "";
    }

    public ArrayList<String> getModelDatabase() {
        return this.model_database;
    }

    public void setModelDatabase(ArrayList<String> model_database) {
        this.model_database = model_database;
    }

    public void setModelDatabase(String model_database) {
        ArrayList<String> v = new ArrayList<String>();
        v.add(model_database);
        this.model_database = v;
    }

    public String getOutputSrc() {
        return this.output_src;
    }

    public void setOutputSrc(String output_src) {
        this.output_src = output_src;
    }

    public String getOutputHand() {
        return this.output_hand;
    }

    public void setOutputHand(String output_hand) {
        this.output_hand = output_hand;
    }

    public String getOutputSql() {
        return this.output_sql;
    }

    public void setOutputSql(String output_sql) {
        this.output_sql = output_sql;
    }

    public String getOutputDoc() {
        return this.output_doc;
    }

    public void setOutputDoc(String output_doc) {
        this.output_doc = output_doc;
    }

    public String getOutputWeb() {
        return this.output_web;
    }

    public void setOutputWeb(String output_web) {
        this.output_web = output_web;
    }

    public String getDbFilepath() {
        return this.db_filepath;
    }

    public void setDbFilepath(String db_filepath) {
        this.db_filepath = db_filepath;
    }

    public String getObjectRelationalMapping() {
        return this.object_relational_mapping;
    }

    public void setObjectRelationalMapping(String object_relational_mapping) {
        this.object_relational_mapping = object_relational_mapping;
    }

    public boolean isExcludeSystem() {
        return this.exclude_system;
    }

    public void setExcludeSystem(boolean exclude_system) {
        this.exclude_system = exclude_system;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getMolgenis_properties() {
        return this.molgenis_properties;
    }

    public void setMolgenis_properties(String molgenisProperties) {
        this.molgenis_properties = molgenisProperties;
    }

    public boolean isDisable_decorators() {
        return this.disable_decorators;
    }

    public void setDisable_decorators(boolean disable_decorators) {
        this.disable_decorators = disable_decorators;
    }

    public void setGenerateTests(boolean generate_tests) {
        this.generate_tests = generate_tests;
    }
}

