/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.fieldtypes;

import java.text.ParseException;
import org.molgenis.MolgenisFieldTypes;
import org.molgenis.fieldtypes.FieldType;
import org.molgenis.model.MolgenisModelException;

public class EnumField
extends FieldType {
    private static final long serialVersionUID = 1L;

    @Override
    public String getJavaPropertyType() {
        return "String";
    }

    @Override
    public String getJavaAssignment(String value) {
        if (value == null || value.equals("")) {
            return "null";
        }
        return "\"" + value + "\"";
    }

    @Override
    public String getJavaPropertyDefault() {
        return this.getJavaAssignment(this.f.getDefaultValue());
    }

    @Override
    public String getMysqlType() throws MolgenisModelException {
        return "ENUM(" + this.toCsv(this.f.getEnumOptions()) + ")";
    }

    @Override
    public String getOracleType() throws MolgenisModelException {
        return "VARCHAR2(255)";
    }

    @Override
    public String getHsqlType() {
        return "VARCHAR(1024)";
    }

    @Override
    public String getXsdType() {
        return "string";
    }

    @Override
    public String getFormatString() {
        return "%s";
    }

    @Override
    public String getCppPropertyType() throws MolgenisModelException {
        return "string";
    }

    @Override
    public String getCppJavaPropertyType() {
        return "Ljava/lang/String;";
    }

    @Override
    public Class<?> getJavaType() {
        return Enum.class;
    }

    @Override
    public Object getTypedValue(String value) throws ParseException {
        throw new UnsupportedOperationException("Unable to cast enum type");
    }

    @Override
    public MolgenisFieldTypes.FieldTypeEnum getEnumType() {
        return MolgenisFieldTypes.FieldTypeEnum.ENUM;
    }

    @Override
    public Object convert(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }
}

