/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.generators;

import freemarker.template.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.molgenis.MolgenisOptions;
import org.molgenis.generators.Generator;
import org.molgenis.model.elements.Model;

public class JpaRepositorySourceGen
extends Generator {
    private static Logger logger = Logger.getLogger(JpaRepositorySourceGen.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(Model model, MolgenisOptions options) throws Exception {
        if (options.generate_tests) {
            return;
        }
        Template template = this.createTemplate("/" + this.getClass().getSimpleName() + ".java.ftl");
        Map<String, Object> templateArgs = this.createTemplateArguments(options);
        File target = new File(this.getSourcePath(options) + "/org/molgenis/data/jpa/JpaRepositoryCollection.java");
        boolean created = target.getParentFile().mkdirs();
        if (!created && !target.getParentFile().exists()) {
            throw new IOException("could not create " + target.getParentFile());
        }
        templateArgs.put("options", options);
        templateArgs.put("model", model);
        templateArgs.put("disable_decorators", options.disable_decorators);
        FileOutputStream targetOut = new FileOutputStream(target);
        try {
            template.process(templateArgs, (Writer)new OutputStreamWriter((OutputStream)targetOut, Charset.forName("UTF-8")));
        }
        finally {
            IOUtils.closeQuietly((OutputStream)targetOut);
        }
        logger.info((Object)("generated " + target));
    }

    @Override
    public String getDescription() {
        return "Generates org.molgenis.data.jpa.JpaEntitySourceImpl";
    }
}

